/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.license;

import java.net.URI;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.apache.maven.plugin.logging.Log;

@ParametersAreNonnullByDefault
public class LicenseBackdoorClient {
    private static final int MAXIMUM_LEGAL_PORT_NUMBER = 65535;
    private static final String BACKDOOR_BASE_PATH = "/rest/license-backdoor/1.0/";
    private static final String USERNAME = "admin";
    private static final String PASSWORD = "admin";
    private final int webPort;
    private final Log log;
    private final String contextPath;
    private final String hostname;
    private final String protocol;

    public LicenseBackdoorClient(int webPort, String protocol, String hostname, String contextPath, Log log) {
        this.contextPath = Objects.requireNonNull(contextPath);
        this.hostname = Objects.requireNonNull(hostname);
        this.log = Objects.requireNonNull(log);
        this.protocol = Objects.requireNonNull(protocol);
        this.webPort = LicenseBackdoorClient.validateWebPort(webPort);
    }

    private static int validateWebPort(int port) {
        if (port <= 0 || port > 65535) {
            throw new IllegalArgumentException("Invalid web port " + port);
        }
        return port;
    }

    public boolean installProductLicense(String license) {
        try {
            HttpResponse response = this.postLicenseAsAdmin(license);
            StatusLine statusLine = response.getStatusLine();
            if (statusLine.getStatusCode() == 200) {
                EntityUtils.consume((HttpEntity)response.getEntity());
                return true;
            }
            this.log.error((CharSequence)String.format("Could not set license: %d %s %s", statusLine.getStatusCode(), statusLine.getReasonPhrase(), EntityUtils.toString((HttpEntity)response.getEntity())));
            return false;
        }
        catch (Exception e) {
            this.log.error((CharSequence)"Could not set license", (Throwable)e);
            return false;
        }
    }

    private HttpResponse postLicenseAsAdmin(String license) throws Exception {
        HttpPost request = new HttpPost(this.addLicenseUri());
        request.setEntity((HttpEntity)new StringEntity(license, ContentType.APPLICATION_JSON));
        return LicenseBackdoorClient.callBackdoorAsAdmin((HttpUriRequest)request);
    }

    private URI addLicenseUri() {
        return UriBuilder.fromPath((String)(StringUtils.strip((String)this.contextPath, (String)"/") + BACKDOOR_BASE_PATH + "licenses")).scheme(this.protocol).host(this.hostname).port(this.webPort).build(new Object[0]);
    }

    private static HttpResponse callBackdoorAsAdmin(HttpUriRequest request) throws Exception {
        return HttpClientBuilder.create().build().execute(LicenseBackdoorClient.asAdmin(request));
    }

    private static <R extends HttpRequest> R asAdmin(R request) throws AuthenticationException {
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials("admin", "admin");
        request.addHeader(new BasicScheme().authenticate((Credentials)credentials, request, null));
        return request;
    }
}

