/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.frontend;

import com.atlassian.maven.plugins.amps.AbstractAmpsMojo;
import com.atlassian.maven.plugins.amps.MavenContext;
import com.atlassian.maven.plugins.amps.util.FileUtils;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="copy-fe-module-manifests", defaultPhase=LifecyclePhase.PROCESS_RESOURCES)
public class CopyFeModuleManifestsMojo
extends AbstractAmpsMojo {
    public static final String MODULE_MANIFESTS_OUTPUT_DIR = "META-INF/fe-module-manifests";
    public static final List<String> SUPPORTED_FILE_NAMES = Arrays.asList("package.json", "package-lock.json", "yarn.lock");
    @Parameter
    private List<String> includedFeModuleManifests;
    @Parameter(property="skipCopyFeModuleManifests")
    private Boolean skipCopyFeModuleManifests;
    @VisibleForTesting
    @Parameter(property="targetDirectory")
    private String feSbomTargetDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (Boolean.TRUE.equals(this.skipCopyFeModuleManifests)) {
            this.getLog().info((CharSequence)"Skipping `copy-fe-module-manifests` execution");
        } else if (this.includedFeModuleManifests == null || this.includedFeModuleManifests.isEmpty()) {
            this.getLog().info((CharSequence)"There were no frontend module manifest files specified to include in the artifact");
        } else {
            this.getLog().info((CharSequence)("The following frontend module manifest files are to be included in the artifact: " + this.includedFeModuleManifests));
            Set<String> absoluteFilePaths = this.resolveToAbsolutePaths(this.includedFeModuleManifests);
            this.validateDeclaredFiles(absoluteFilePaths, this.getLog());
            File commonDirectory = FileUtils.findBaseDirectory(absoluteFilePaths);
            File outputDirectory = this.createOutputSubdirectory(this.getOutputDirectory());
            for (String absoluteFilePath : absoluteFilePaths) {
                File sourceFile = this.getSourceFile(absoluteFilePath);
                String commonDirRelativeFilePath = this.getCommonDirRelativePath(commonDirectory, absoluteFilePath);
                File outputFile = this.getOutputFile(commonDirRelativeFilePath, outputDirectory);
                this.copyWithOverwrite(sourceFile, outputFile, this.getLog());
            }
        }
    }

    @VisibleForTesting
    String getOutputDirectory() {
        if (!StringUtils.isEmpty((CharSequence)this.feSbomTargetDirectory)) {
            return this.feSbomTargetDirectory;
        }
        return this.getMavenContext().getProject().getBuild().getOutputDirectory();
    }

    @VisibleForTesting
    String getCommonDirRelativePath(File commonDirectory, String absoluteFilePath) throws MojoExecutionException {
        String commonDirectoryPathLiteral;
        Pattern pathStartsWithCommonDirPattern;
        boolean pathStartsWithCommonDir;
        String commonDirectoryPath = commonDirectory.getAbsolutePath();
        if (!absoluteFilePath.equals(File.separator) && !commonDirectoryPath.endsWith(File.separator)) {
            commonDirectoryPath = commonDirectoryPath + File.separator;
        }
        if (!(pathStartsWithCommonDir = (pathStartsWithCommonDirPattern = Pattern.compile(String.format("^%s.*$", commonDirectoryPathLiteral = Pattern.quote(commonDirectoryPath)))).matcher(absoluteFilePath).matches())) {
            throw new MojoExecutionException("File '" + absoluteFilePath + "' is outside base directory '" + commonDirectoryPath);
        }
        return absoluteFilePath.replaceFirst(commonDirectoryPathLiteral, "");
    }

    private Set<String> resolveToAbsolutePaths(List<String> paths) {
        return paths.stream().map(filepath -> {
            Path path = Paths.get(filepath, new String[0]);
            if (path.isAbsolute()) {
                return path.normalize().toString();
            }
            return Paths.get(this.getMavenContext().getProject().getBasedir().getAbsolutePath(), new String[0]).resolve((String)filepath).normalize().toString();
        }).collect(Collectors.toSet());
    }

    @Nonnull
    @VisibleForTesting
    File createOutputSubdirectory(String outputDirectory) throws MojoExecutionException {
        File feModuleManifestsDir = FileUtils.file(outputDirectory, MODULE_MANIFESTS_OUTPUT_DIR);
        if (feModuleManifestsDir.exists() || feModuleManifestsDir.mkdirs()) {
            return feModuleManifestsDir;
        }
        throw new MojoExecutionException("Output directory for frontend module manifest files couldn't be created");
    }

    private File getSourceFile(String absoluteFilePath) {
        return new File(absoluteFilePath);
    }

    private File getOutputFile(String relativeFilePath, File outputBaseDirectory) {
        return new File(outputBaseDirectory, relativeFilePath);
    }

    @VisibleForTesting
    void copyWithOverwrite(File sourceFile, File outputFile, Log log) throws MojoExecutionException {
        String outputPath = outputFile.getAbsolutePath();
        if (outputFile.exists()) {
            log.warn((CharSequence)String.format("File <%s> already exists and is going to be overwritten.", outputPath));
        }
        try {
            org.apache.commons.io.FileUtils.copyFile((File)sourceFile, (File)outputFile);
        }
        catch (IOException exception) {
            throw new MojoExecutionException(String.format("Copying from <%s> to <%s> failed", sourceFile.getAbsolutePath(), outputPath), (Exception)exception);
        }
    }

    @VisibleForTesting
    void validateDeclaredFiles(Set<String> filepaths, Log logger) throws MojoExecutionException {
        ArrayList validationErrors = new ArrayList();
        for (String filepath : filepaths) {
            File file = new File(filepath);
            CopyFeModuleManifestsMojo.validateFileExists(filepath, file).ifPresent(validationErrors::add);
            CopyFeModuleManifestsMojo.validateFilenameIsSupported(filepath, file).ifPresent(validationErrors::add);
        }
        if (!validationErrors.isEmpty()) {
            validationErrors.forEach(arg_0 -> ((Log)logger).error(arg_0));
            throw new MojoExecutionException("Validation of includedFeModuleManifests failed, check the logs above for more details");
        }
    }

    @Nonnull
    private static Optional<String> validateFileExists(String filepath, File file) {
        if (file.exists()) {
            return Optional.empty();
        }
        return Optional.of("File doesn't exist: " + filepath);
    }

    @Nonnull
    private static Optional<String> validateFilenameIsSupported(String filepath, File file) {
        if (SUPPORTED_FILE_NAMES.contains(file.getName())) {
            return Optional.empty();
        }
        return Optional.of(String.format("Only %s files are supported, not %s", SUPPORTED_FILE_NAMES, filepath));
    }

    @Override
    @VisibleForTesting
    protected void setMavenContext(MavenContext mavenContext) {
        super.setMavenContext(mavenContext);
    }
}

