/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.database;

import com.atlassian.maven.plugins.amps.DataSource;
import com.atlassian.maven.plugins.amps.database.AbstractDatabase;
import com.atlassian.maven.plugins.amps.product.ImportMethod;
import java.io.File;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@ParametersAreNonnullByDefault
public abstract class AbstractOracleDatabase
extends AbstractDatabase {
    protected static final String DATA_PUMP_DIR = "DATA_PUMP_DIR";
    private static final String ARGUMENT = "argument";

    protected AbstractOracleDatabase(Log log, String dbType) {
        super(log, false, dbType, "oracle.jdbc.OracleDriver", "jdbc:oracle");
    }

    @Override
    protected String dropDatabase(DataSource dataSource) {
        return null;
    }

    @Override
    protected String dropUser(DataSource dataSource) {
        return null;
    }

    @Override
    protected String createDatabase(DataSource dataSource) {
        return null;
    }

    @Override
    protected String createUser(DataSource dataSource) {
        return null;
    }

    @Override
    protected String grantPermissionForUser(DataSource dataSource) {
        return null;
    }

    @Override
    protected String getDatabaseName(DataSource dataSource) {
        return dataSource.getSchema();
    }

    @Override
    public Xpp3Dom getExecMavenToolImportConfiguration(DataSource dataSource) throws MojoExecutionException {
        Xpp3Dom configDatabaseTool = null;
        if (ImportMethod.IMPDP.equals((Object)ImportMethod.getValueOf(dataSource.getImportMethod()))) {
            File dumpFile = new File(dataSource.getDumpFilePath());
            File dumpFileDirectory = dumpFile.getParentFile();
            String dumpFileName = dumpFile.getName();
            AbstractOracleDatabase.setExecutableReadWrite(dumpFile);
            AbstractOracleDatabase.setExecutableReadWrite(dumpFileDirectory);
            configDatabaseTool = MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("executable"), "impdp"), MojoExecutor.element(MojoExecutor.name("arguments"), MojoExecutor.element(MojoExecutor.name(ARGUMENT), dataSource.getUsername() + "/" + dataSource.getPassword()), MojoExecutor.element(MojoExecutor.name(ARGUMENT), "DUMPFILE=" + dumpFileName), MojoExecutor.element(MojoExecutor.name(ARGUMENT), "DIRECTORY=DATA_PUMP_DIR")));
        }
        return configDatabaseTool;
    }

    private static void setExecutableReadWrite(File file) throws MojoExecutionException {
        AbstractOracleDatabase.ensure(file, f -> f.setExecutable(true, false));
        AbstractOracleDatabase.ensure(file, f -> f.setReadable(true, false));
        AbstractOracleDatabase.ensure(file, f -> f.setWritable(true, false));
    }

    private static void ensure(File file, Function<File, Boolean> action) throws MojoExecutionException {
        if (!Boolean.TRUE.equals(action.apply(file))) {
            throw new MojoExecutionException("Could not modify the file " + file.getAbsolutePath());
        }
    }

    @Override
    @Nonnull
    public Xpp3Dom getSqlMavenCreateConfiguration(DataSource dataSource) {
        String sql = this.getSqlToDropAndCreateUser(dataSource);
        this.log.info((CharSequence)("Oracle initialization database SQL: " + sql));
        Xpp3Dom sqlPluginConfiguration = this.systemDatabaseConfiguration(dataSource);
        AbstractOracleDatabase.addChild(sqlPluginConfiguration, "sqlCommand", sql);
        AbstractOracleDatabase.addChild(sqlPluginConfiguration, "delimiter", "/");
        AbstractOracleDatabase.addChild(sqlPluginConfiguration, "delimiterType", "row");
        AbstractOracleDatabase.addChild(sqlPluginConfiguration, "driverProperties", dataSource.getSqlPluginJdbcDriverProperties());
        return sqlPluginConfiguration;
    }

    @Nonnull
    protected abstract String getSqlToDropAndCreateUser(DataSource var1);

    private static void addChild(Xpp3Dom parentNode, String childName, String childValue) {
        parentNode.addChild(MojoExecutor.element(MojoExecutor.name(childName), childValue).toDom());
    }
}

