/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps;

import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public class MavenContext {
    private static final Map<String, String> DEFAULT_PLUGIN_VERSIONS = new LinkedHashMap<String, String>();
    private final BuildPluginManager buildPluginManager;
    private final List<MavenProject> reactor;
    private final Log log;
    private final MavenProject project;
    private final MavenSession session;
    private Properties versionOverrides;
    private Set<String> versionOverridesSet;
    private String versionOverridesPath;

    public MavenContext(MavenProject project, List<MavenProject> reactor, MavenSession session, BuildPluginManager buildPluginManager, Log log) {
        this.buildPluginManager = buildPluginManager;
        this.log = log;
        this.project = project;
        this.reactor = reactor;
        this.session = session;
    }

    public MavenProject getProject() {
        return this.project;
    }

    MavenSession getSession() {
        return this.session;
    }

    public Log getLog() {
        return this.log;
    }

    public Properties getVersionOverrides() {
        if (this.versionOverrides == null) {
            File overridesFile;
            this.versionOverrides = new Properties();
            if (this.versionOverridesPath != null && (overridesFile = new File(this.versionOverridesPath)).exists() && overridesFile.canRead()) {
                this.loadVersionOverridesFrom(overridesFile);
            }
            if (this.versionOverridesSet != null && this.project.getPluginManagement() != null) {
                this.loadVersionOverridesFromPluginManagement();
            }
        }
        return this.versionOverrides;
    }

    private void loadVersionOverridesFromPluginManagement() {
        HashSet<String> found = new HashSet<String>();
        for (Plugin plg : this.project.getPluginManagement().getPlugins()) {
            if (!this.versionOverridesSet.contains(plg.getArtifactId())) continue;
            this.versionOverrides.setProperty(plg.getArtifactId(), plg.getVersion());
            found.add(plg.getArtifactId());
        }
        Sets.SetView diff = Sets.difference(this.versionOverridesSet, found);
        if (!diff.isEmpty()) {
            this.getLog().warn((CharSequence)("Plugin artifactId(s) defined in 'versionOverrides' parameter but no associated entry found in <pluginManagement> section for " + diff));
        }
    }

    private void loadVersionOverridesFrom(File overridesFile) {
        try (FileInputStream overridesIn = FileUtils.openInputStream((File)overridesFile);){
            this.versionOverrides.load(overridesIn);
        }
        catch (IOException e) {
            this.log.error((CharSequence)("unable to load version overrides file as Properties: " + overridesFile.getAbsolutePath()), (Throwable)e);
        }
    }

    public List<MavenProject> getReactor() {
        return this.reactor;
    }

    public MavenContext with(MavenProject project, List<MavenProject> reactor, MavenSession session) {
        return new MavenContext(project, reactor, session, this.buildPluginManager, this.log);
    }

    public MojoExecutor.ExecutionEnvironment getExecutionEnvironment() {
        return MojoExecutor.executionEnvironment(this.project, this.session, this.buildPluginManager);
    }

    public void setVersionOverridesPath(String versionOverridesPath) {
        this.versionOverridesPath = versionOverridesPath;
    }

    void setVersionOverrides(Set<String> versionOverrides) {
        this.versionOverridesSet = versionOverrides;
    }

    @Nonnull
    public Plugin getPlugin(String groupId, String artifactId) {
        return MojoExecutor.plugin(groupId, artifactId, this.getPluginVersion(artifactId));
    }

    private String getPluginVersion(String artifactId) {
        String defaultPluginVersion = DEFAULT_PLUGIN_VERSIONS.get(artifactId);
        String pluginVersion = this.getVersionOverrides().getProperty(artifactId, defaultPluginVersion);
        if (StringUtils.isBlank((CharSequence)pluginVersion)) {
            throw new IllegalArgumentException(String.format("No version available for '%s'", artifactId));
        }
        return pluginVersion;
    }

    static {
        DEFAULT_PLUGIN_VERSIONS.put("atlassian-pdk", "2.3.3");
        DEFAULT_PLUGIN_VERSIONS.put("build-helper-maven-plugin", "3.0.0");
        DEFAULT_PLUGIN_VERSIONS.put("cargo-maven2-plugin", "1.6.10");
        DEFAULT_PLUGIN_VERSIONS.put("exec-maven-plugin", "1.2.1");
        DEFAULT_PLUGIN_VERSIONS.put("maven-archetype-plugin", "3.2.0");
        DEFAULT_PLUGIN_VERSIONS.put("maven-bundle-plugin", "3.5.0");
        DEFAULT_PLUGIN_VERSIONS.put("maven-cli-plugin", "1.0.11");
        DEFAULT_PLUGIN_VERSIONS.put("maven-dependency-plugin", "3.1.1");
        DEFAULT_PLUGIN_VERSIONS.put("maven-deploy-plugin", "2.8.2");
        DEFAULT_PLUGIN_VERSIONS.put("maven-failsafe-plugin", "2.22.1");
        DEFAULT_PLUGIN_VERSIONS.put("maven-help-plugin", "3.2.0");
        DEFAULT_PLUGIN_VERSIONS.put("maven-install-plugin", "2.5.2");
        DEFAULT_PLUGIN_VERSIONS.put("maven-jar-plugin", "3.0.2");
        DEFAULT_PLUGIN_VERSIONS.put("maven-javadoc-plugin", "3.1.1");
        DEFAULT_PLUGIN_VERSIONS.put("maven-release-plugin", "2.5.3");
        DEFAULT_PLUGIN_VERSIONS.put("maven-resources-plugin", "2.6");
        DEFAULT_PLUGIN_VERSIONS.put("maven-surefire-plugin", "2.22.1");
        DEFAULT_PLUGIN_VERSIONS.put("sql-maven-plugin", "1.5");
        DEFAULT_PLUGIN_VERSIONS.put("yuicompressor-maven-plugin", "1.5.1");
    }
}

