/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.mail.msgraph.service;

import com.atlassian.mail.msgraph.service.CouldNotRetrieveAccessTokenException;
import com.atlassian.mail.msgraph.settings.providers.MailConnectionSettingsProvider;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.microsoft.graph.authentication.IAuthenticationProvider;
import com.microsoft.graph.http.GraphServiceException;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.GraphServiceClient;
import com.microsoft.graph.requests.MailFolderCollectionPage;
import com.microsoft.graph.requests.MailFolderCollectionRequest;
import com.microsoft.graph.requests.MessageCollectionPage;
import com.microsoft.graph.requests.MessageCollectionRequest;
import com.microsoft.graph.requests.MessageCollectionRequestBuilder;
import com.microsoft.graph.requests.UserRequestBuilder;
import io.atlassian.fugue.Checked;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Unit;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import okhttp3.Request;
import org.joda.time.DateTime;
import org.joda.time.format.ISODateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MicrosoftGraphMailClient {
    private static final Logger logger = LoggerFactory.getLogger(MicrosoftGraphMailClient.class);
    public static final Integer MS_LIST_MESSAGES_API_PAGE_SIZE = 10;
    public static final Integer HYBRID_MS_EXCHANGE_SERVER_ERROR = 405;
    private final GraphServiceClient<Request> graphClient;
    private io.atlassian.fugue.Option<String> userPrincipalName = io.atlassian.fugue.Option.none();

    public MicrosoftGraphMailClient(MailConnectionSettingsProvider settingsProvider) {
        this.graphClient = this.getGraphClient(settingsProvider);
        this.userPrincipalName = io.atlassian.fugue.Option.option((Object)settingsProvider.getUserName());
    }

    @VisibleForTesting
    protected MicrosoftGraphMailClient(GraphServiceClient<Request> graphClient, String userPrincipalName) {
        this.graphClient = graphClient;
        this.userPrincipalName = io.atlassian.fugue.Option.option((Object)userPrincipalName);
    }

    @Nonnull
    @VisibleForTesting
    GraphServiceClient<Request> getGraphClient(MailConnectionSettingsProvider settingsProvider) {
        return GraphServiceClient.builder().authenticationProvider((IAuthenticationProvider)new SimpleAuthProvider(() -> (String)settingsProvider.getAuthenticationToken().getOrThrow(() -> new CouldNotRetrieveAccessTokenException(String.format("Could not retrieve access token for connection [%s]", settingsProvider.getMailSettings().getId()))))).buildClient();
    }

    @Nonnull
    public Either<Throwable, MessageCollectionPage> getMessages(DateTime pullFromDate, String folderId) {
        Function<UserRequestBuilder, MessageCollectionPage> getMessages = userRequest -> (MessageCollectionPage)((MessageCollectionRequest)userRequest.mailFolders(folderId).messages().buildRequest(this.getGraphClientQueryOptions(pullFromDate))).top(MS_LIST_MESSAGES_API_PAGE_SIZE.intValue()).select("id").get();
        return this.executeGraphClientRequest(g -> (MessageCollectionPage)getMessages.apply(this.userRequestBuilder((GraphServiceClient<Request>)g)));
    }

    @Nonnull
    public Either<Throwable, MessageCollectionPage> getNextMessagesPage(MessageCollectionPage messagesPage) {
        return this.executeGraphClientRequest(g -> (MessageCollectionPage)((MessageCollectionRequest)((MessageCollectionRequestBuilder)Objects.requireNonNull(messagesPage.getNextPage())).buildRequest(new Option[0])).get());
    }

    @Nonnull
    public List<Message> getMessageStubsFromMessagePage(MessageCollectionPage messagesPage) {
        return messagesPage.getCurrentPage().stream().flatMap(messageStub -> this.getMimeMessage((com.microsoft.graph.models.Message)messageStub).toStream()).collect(Collectors.toList());
    }

    @Nonnull
    public Either<Throwable, List<Message>> getMessageStubsFromMessagePageNew(MessageCollectionPage messagesPage) {
        List messageStubs = messagesPage.getCurrentPage();
        if (messageStubs.size() == 0) {
            return Either.right(new ArrayList());
        }
        ArrayList<Object> messages = new ArrayList<Object>();
        Either<Throwable, Message> mimeMessage = null;
        for (com.microsoft.graph.models.Message messageStub : messageStubs) {
            mimeMessage = this.getMimeMessage(messageStub);
            if (!mimeMessage.isRight()) continue;
            messages.add(mimeMessage.right().get());
        }
        if (messages.isEmpty() && mimeMessage.isLeft()) {
            try {
                GraphServiceException exception = (GraphServiceException)mimeMessage.left().get();
                if (exception.getResponseCode() == HYBRID_MS_EXCHANGE_SERVER_ERROR.intValue()) {
                    return Either.left((Object)mimeMessage.left().get());
                }
            }
            catch (Exception e) {
                return Either.right(messages);
            }
        }
        return Either.right(messages);
    }

    @Nonnull
    public Either<Throwable, Message> getMimeMessage(com.microsoft.graph.models.Message messageStub) {
        String pathForMimeMessage = this.userRequestString() + "/messages/" + messageStub.id + "/$value";
        Properties props = new Properties();
        Session session = Session.getDefaultInstance((Properties)props, null);
        Function<Either, Either> fetchMimeMessage = eitherResult -> eitherResult.flatMap(stream -> {
            try {
                MicrosoftMimeMessage msg = new MicrosoftMimeMessage(messageStub.id, session, (InputStream)stream);
                return Either.right((Object)((Object)msg));
            }
            catch (MessagingException e) {
                logger.error(String.format("Failed construct MimeMessage from message stream (id: %s)", messageStub.id), (Throwable)e);
                return Either.left((Object)((Object)e));
            }
        });
        return fetchMimeMessage.apply(this.executeGraphClientRequest(g -> (InputStream)g.customRequest(pathForMimeMessage, InputStream.class).buildRequest(new Option[0]).get()));
    }

    public Either<Throwable, MailFolderCollectionPage> getFolderIdByName(String name) {
        Function<UserRequestBuilder, MailFolderCollectionPage> getFolderIdByName = userRequest -> (MailFolderCollectionPage)((MailFolderCollectionRequest)userRequest.mailFolders().buildRequest(new Option[0])).filter("displayName eq '" + name + "'").get();
        return this.executeGraphClientRequest(g -> (MailFolderCollectionPage)getFolderIdByName.apply(this.userRequestBuilder((GraphServiceClient<Request>)g)));
    }

    private UserRequestBuilder userRequestBuilder(GraphServiceClient<Request> g) {
        return (UserRequestBuilder)this.userPrincipalName.map(arg_0 -> g.users(arg_0)).getOrThrow(() -> new IllegalStateException("User principal name is required but not provided"));
    }

    private String userRequestString() {
        return (String)this.userPrincipalName.map(name -> String.format("/users('%s')", name)).getOrThrow(() -> new IllegalStateException("User principal name is required but not provided"));
    }

    public Either<Throwable, Unit> markMessageRead(Message message) {
        if (message instanceof MicrosoftMimeMessage) {
            MicrosoftMimeMessage msMessage = (MicrosoftMimeMessage)message;
            com.microsoft.graph.models.Message markAsRead = new com.microsoft.graph.models.Message();
            markAsRead.isRead = true;
            markAsRead.id = msMessage.microsoftMessageId;
            logger.info(String.format("Marking message with microsoftMessageId (%s) as read", markAsRead.id));
            Function<UserRequestBuilder, com.microsoft.graph.models.Message> markMessageRead = userRequest -> userRequest.messages(msMessage.getMicrosoftMessageId()).buildRequest(new Option[0]).patch(markAsRead);
            return this.executeGraphClientRequest(g -> (com.microsoft.graph.models.Message)markMessageRead.apply(this.userRequestBuilder((GraphServiceClient<Request>)g))).map(m -> Unit.VALUE);
        }
        throw new IllegalArgumentException(this.getClass() + " asked to handle non-Microsoft source message");
    }

    private <T> Either<Throwable, T> executeGraphClientRequest(Function<GraphServiceClient<Request>, T> func) {
        Object response;
        Either either = Checked.now(() -> func.apply(this.graphClient)).toEither().leftMap(l -> l);
        if (either.isLeft()) {
            this.handleGraphClientResponseException((Throwable)either.left().get());
        } else if (either.isRight() && (response = either.right().get()) != null) {
            this.handleGraphClientSuccess();
        }
        return either;
    }

    private void handleGraphClientResponseException(Throwable th) {
        if (th instanceof GraphServiceException) {
            GraphServiceException ex = (GraphServiceException)th;
            logger.error(String.valueOf(ex));
        } else {
            logger.error(String.valueOf(th));
        }
    }

    private void handleGraphClientSuccess() {
        logger.debug("Graph client request successful");
    }

    private List<QueryOption> getGraphClientQueryOptions(DateTime pullFromDate) {
        String pullFromDateISO = pullFromDate.toString(ISODateTimeFormat.dateTime());
        QueryOption unreadAndReceivedAfterOption = new QueryOption("$filter", (Object)("isRead eq false and receivedDateTime ge " + pullFromDateISO));
        QueryOption oldestFirstOption = new QueryOption("$orderBy", (Object)"receivedDateTime asc");
        return ImmutableList.of((Object)unreadAndReceivedAfterOption, (Object)oldestFirstOption);
    }

    @VisibleForTesting
    public static class MicrosoftMimeMessage
    extends MimeMessage {
        private final String microsoftMessageId;

        public MicrosoftMimeMessage(String messageStubId, Session session, InputStream is) throws MessagingException {
            super(session, is);
            this.microsoftMessageId = messageStubId;
        }

        public String getMicrosoftMessageId() {
            return this.microsoftMessageId;
        }
    }

    private static class SimpleAuthProvider
    implements IAuthenticationProvider {
        final Supplier<String> tokenSupplier;

        public SimpleAuthProvider(Supplier<String> tokenSupplier) {
            this.tokenSupplier = tokenSupplier;
        }

        @Nonnull
        public CompletableFuture<String> getAuthorizationTokenAsync(@Nonnull URL requestUrl) {
            return CompletableFuture.completedFuture(this.tokenSupplier.get());
        }
    }
}

