/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.watch.nio.file.internal;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.WatchService;

public class NativeCapable {
    private static boolean capable = NativeCapable.tryForDecentWatcher();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean tryForDecentWatcher() {
        boolean capable = false;
        double jdkVersion = NativeCapable.getJavaVersion();
        if (jdkVersion >= 1.7) {
            capable = true;
            WatchService watchService = null;
            try {
                watchService = FileSystems.getDefault().newWatchService();
                if (watchService.getClass().getSimpleName().contains("PollingWatchService")) {
                    capable = false;
                }
            }
            catch (IOException iOException) {
            }
            finally {
                NativeCapable.closeQuietly(watchService);
            }
        }
        return capable;
    }

    private static double getJavaVersion() {
        int pos;
        String version = System.getProperty("java.version");
        int count = 0;
        for (pos = 0; pos < version.length() && count < 2; ++pos) {
            if (version.charAt(pos) != '.') continue;
            ++count;
        }
        return Double.parseDouble(version.substring(0, --pos));
    }

    private static void closeQuietly(WatchService watchService) {
        if (watchService != null) {
            try {
                watchService.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static boolean isCapable() {
        return capable;
    }

    public static void set4Testing(boolean flag) {
        capable = flag;
    }
}

