/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.labs.restbrowser.provider;

import com.atlassian.jira.plugin.rpc.SoapModuleDescriptor;
import com.atlassian.labs.restbrowser.plugin.AbstractSoapService;
import com.atlassian.labs.restbrowser.plugin.SoapService;
import com.atlassian.labs.restbrowser.provider.SoapServiceProvider;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.List;

public class Jira6SoapServiceProvider
implements SoapServiceProvider {
    private final PluginAccessor pluginAccessor;
    private final Function<SoapModuleDescriptor, JiraSoapService> transformFunction = new Function<SoapModuleDescriptor, JiraSoapService>(){

        public JiraSoapService apply(SoapModuleDescriptor moduleDescriptor) {
            if (moduleDescriptor == null) {
                return null;
            }
            return new JiraSoapService(moduleDescriptor);
        }
    };

    public Jira6SoapServiceProvider(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    @Override
    public Iterable<? extends SoapService> getSoapServices() {
        List soapModuleDescriptors = this.pluginAccessor.getEnabledModuleDescriptorsByClass(SoapModuleDescriptor.class);
        return Collections2.transform((Collection)soapModuleDescriptors, this.transformFunction);
    }

    private final class JiraSoapService
    extends AbstractSoapService<SoapModuleDescriptor> {
        public JiraSoapService(SoapModuleDescriptor moduleDescriptor) {
            this.moduleDescriptor = moduleDescriptor;
        }

        @Override
        public String getServicePath() {
            return ((SoapModuleDescriptor)this.moduleDescriptor).getServicePath();
        }

        @Override
        public Class<?> getPublishedInterface() {
            return ((SoapModuleDescriptor)this.moduleDescriptor).getPublishedInterface();
        }
    }
}

