/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.labs.restbrowser.servlet;

import com.atlassian.labs.restbrowser.plugin.SoapService;
import com.atlassian.labs.restbrowser.provider.SoapServiceProvider;
import com.atlassian.labs.restbrowser.rest.model.RestDescriptor;
import com.atlassian.labs.restbrowser.servlet.RequiresLoginServlet;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.predicate.ModuleDescriptorPredicate;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestBrowserServlet
extends RequiresLoginServlet {
    private static final Logger log = LoggerFactory.getLogger(RestBrowserServlet.class);
    private static final String BROWSER_TEMPLATE = "/templates/browser.vm";
    private final PluginAccessor pluginAccessor;
    private final SoapServiceProvider soapServiceProvider;
    private final ApplicationProperties applicationProperties;

    public RestBrowserServlet(PluginAccessor pluginAccessor, SoapServiceProvider soapServiceProvider, UserManager userManager, TemplateRenderer renderer, LoginUriProvider loginUriProvider, ApplicationProperties applicationProperties) {
        super(userManager, renderer, loginUriProvider);
        this.applicationProperties = applicationProperties;
        this.pluginAccessor = (PluginAccessor)Preconditions.checkNotNull((Object)pluginAccessor, (Object)"pluginAccessor");
        this.soapServiceProvider = (SoapServiceProvider)Preconditions.checkNotNull((Object)soapServiceProvider, (Object)"soapServiceProvider");
    }

    @Override
    public Map<String, Object> getContext(HttpServletRequest req) {
        HashMap context = Maps.newHashMap();
        context.put("restDescriptors", this.getRestDescriptors());
        context.put("jsonRpcDescriptors", this.getJsonRpcDescriptors());
        context.put("devMode", System.getProperty("atlassian.dev.mode"));
        context.put("applicationProperties", this.applicationProperties);
        return context;
    }

    @Override
    public String getTemplatePath() {
        return BROWSER_TEMPLATE;
    }

    private List<RestDescriptor> getJsonRpcDescriptors() {
        ArrayList jsonRpcDescriptors = Lists.newArrayList();
        Iterable<? extends SoapService> soaps = this.soapServiceProvider.getSoapServices();
        for (SoapService soapService : soaps) {
            RestDescriptor.Builder builder = new RestDescriptor.Builder();
            Plugin plugin = soapService.getPlugin();
            builder.pluginKey(plugin.getKey()).pluginCompleteKey(soapService.getCompleteKey()).pluginName(plugin.getName()).pluginDescription(soapService.getDescription()).basePath("/rpc/json-rpc").version(soapService.getServicePath());
            jsonRpcDescriptors.add(builder.build());
        }
        return jsonRpcDescriptors;
    }

    private List<RestDescriptor> getRestDescriptors() {
        Collection restServlets = this.pluginAccessor.getModuleDescriptors(new ModuleDescriptorOfClassNamePredicate("com.atlassian.plugins.rest.module.RestServletFilterModuleDescriptor"));
        ArrayList<RestDescriptor> restDescriptors = new ArrayList<RestDescriptor>(restServlets.size());
        for (ModuleDescriptor servlet : restServlets) {
            String version;
            String basePath;
            Class[] params = new Class[]{};
            Object[] args = new Object[]{};
            try {
                Method getBasePath = servlet.getClass().getMethod("getBasePath", params);
                basePath = (String)getBasePath.invoke((Object)servlet, args);
                Method getVersion = servlet.getClass().getMethod("getVersion", params);
                Object apiVersion = getVersion.invoke((Object)servlet, args);
                version = apiVersion.toString();
            }
            catch (Exception e) {
                continue;
            }
            Plugin plugin = servlet.getPlugin();
            RestDescriptor.Builder builder = new RestDescriptor.Builder().basePath(basePath).version(version).pluginCompleteKey(servlet.getCompleteKey()).pluginKey(plugin.getKey()).pluginName(plugin.getName()).pluginDescription(servlet.getDescription());
            restDescriptors.add(builder.build());
        }
        return restDescriptors;
    }

    public class ModuleDescriptorOfClassNamePredicate<T>
    implements ModuleDescriptorPredicate<T> {
        private final String moduleDescriptorClass;

        public ModuleDescriptorOfClassNamePredicate(String targetClass) {
            this.moduleDescriptorClass = targetClass;
        }

        public boolean matches(ModuleDescriptor<? extends T> moduleDescriptor) {
            return moduleDescriptor != null && moduleDescriptor.getClass().getName().equals(this.moduleDescriptorClass);
        }
    }
}

