package com.atlassian.labs.httpservice.descriptors;

import com.atlassian.plugin.module.LegacyModuleFactory;
import com.atlassian.plugin.servlet.descriptors.ServletModuleDescriptor;
import com.atlassian.plugin.servlet.ServletModuleManager;
import com.atlassian.plugin.hostcontainer.HostContainer;
import com.atlassian.plugin.hostcontainer.DefaultHostContainer;
import com.atlassian.plugin.Plugin;

import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletConfig;
import java.util.*;
import java.io.IOException;

/**
 *
 */
public class HttpServiceServletModuleDescriptor extends ServletModuleDescriptor
{
    private final List<String> paths;
    private final Map<String, String> initParams;
    private final String completeKey;
    private final String key;
    private final Plugin plugin;
    private final HttpServlet servlet;

    /**
     * Creates a descriptor that uses a module factory to create instances
     *
     * @since 2.2.0
     */
    public HttpServiceServletModuleDescriptor(Plugin plugin, final Servlet originalServlet, String alias, Dictionary initParams, ServletModuleManager servletModuleManager)
    {
        super(new LegacyModuleFactory(), servletModuleManager);
        this.plugin = plugin;
        HttpServlet servlet = null;
        if (!(originalServlet instanceof HttpServlet))
        {
            servlet = new HttpServlet()
            {
                @Override
                public void init(ServletConfig config) throws ServletException
                {
                    originalServlet.init(config);
                }

                @Override
                protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException
                {
                    originalServlet.service(req, resp);
                }

                @Override
                public void destroy()
                {
                    originalServlet.destroy();
                }
            };
            //throw new IllegalArgumentException("Only HttpServlet instances are supported");
        } else
        {
            servlet = (HttpServlet) originalServlet;
        }
        this.servlet = servlet;
        paths = Arrays.asList(alias, "/".equals( alias ) ? "/*" : alias + "/*");
        Map<String,String> tmp = new HashMap<String, String>();
        for (Enumeration e = initParams.keys(); e.hasMoreElements(); )
        {
            String key = (String) e.nextElement();
            tmp.put(key, (String) initParams.get(key));
        }
        this.initParams = Collections.unmodifiableMap(tmp);
        this.key = alias + servlet.getClass().getSimpleName();
        this.completeKey = plugin.getKey() + ":" + this.key;
    }

    @Override
    public String getPluginKey()
    {
        return plugin.getKey();
    }

    @Override
    public Plugin getPlugin()
    {
        return plugin;
    }

    @Override
    public HttpServlet getModule()
    {
        return servlet;
    }

    @Override
    public String getKey()
    {
        return this.key;
    }

    @Override
    public String getCompleteKey()
    {
        return completeKey;
    }

    @Override
    public String getName()
    {
        return servlet.getClass().getSimpleName();
    }

    @Override
    public Class<HttpServlet> getModuleClass()
    {
        return (Class<HttpServlet>) servlet.getClass();
    }

    @Override
    public List<String> getPaths()
    {
        return paths;
    }

    @Override
    public Map<String,String> getInitParams()
    {
        return initParams;
    }
}
