/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.livereload;

import com.google.gson.Gson;
import com.netiq.websocket.WebSocket;
import com.netiq.websocket.WebSocketServer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class LiveReloadServer
extends WebSocketServer
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(LiveReloadServer.class);
    public static final Integer DEFAULT_PORT = 35730;
    public static final String PROTOCOL_7 = "http://livereload.com/protocols/official-7";
    private final String helloCommand;

    public LiveReloadServer() {
        Gson gson = new Gson();
        this.helloCommand = gson.toJson((Object)new HelloCommand());
    }

    public void afterPropertiesSet() throws Exception {
        this.setPort(DEFAULT_PORT);
        this.start();
        log.debug("started livereload server on port " + DEFAULT_PORT);
        System.out.print("___________            ________     ______            _________\n___  /___(_)__   _________  __ \\_______  /___________ ______  /\n__  / __  /__ | / /  _ \\_  /_/ /  _ \\_  /_  __ \\  __ `/  __  / \n_  /___  / __ |/ //  __/  _, _//  __/  / / /_/ / /_/ // /_/ /  \n/_____/_/  _____/ \\___//_/ |_| \\___//_/  \\____/\\__,_/ \\__,_/   \n                                                               \n__________             ______ ______    ______________         \n___  ____/____________ ___  /____  /__________  /__  /         \n__  __/  __  __ \\  __ `/_  __ \\_  /_  _ \\  __  /__  /          \n_  /___  _  / / / /_/ /_  /_/ /  / /  __/ /_/ /  /_/           \n/_____/  /_/ /_/\\__,_/ /_.___//_/  \\___/\\__,_/  (_)            \n                                                               ");
    }

    public void destroy() throws Exception {
        this.stop();
        log.debug("stoppped livereload server");
    }

    public void onClientOpen(WebSocket webSocket) {
        try {
            webSocket.send(this.helloCommand);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void onClientClose(WebSocket webSocket) {
    }

    public void onClientMessage(WebSocket webSocket, String s) {
    }

    public void onError(Throwable t) {
        t.printStackTrace();
    }

    static class HelloCommand {
        private String command = "hello";
        private List<String> protocols = new ArrayList<String>();
        private String serverName;

        HelloCommand() {
            this.protocols.add(LiveReloadServer.PROTOCOL_7);
            this.serverName = "Atlassian Live Reload";
        }
    }
}

