/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.jwk;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.KeyType;
import com.nimbusds.jose.jwk.OctetSequenceKey;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jose.jwk.Use;
import com.nimbusds.jose.util.Base64;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jose.util.JSONObjectUtils;
import java.net.URL;
import java.text.ParseException;
import java.util.Collections;
import java.util.List;
import javax.mail.internet.ContentType;
import javax.mail.internet.ParameterList;
import net.minidev.json.JSONAware;
import net.minidev.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JWK
implements JSONAware {
    public static final ContentType MIME_TYPE;
    private final KeyType kty;
    private final Use use;
    private final Algorithm alg;
    private final String kid;
    private final URL x5u;
    private final Base64URL x5t;
    private final List<Base64> x5c;

    public JWK(KeyType kty, Use use, Algorithm alg, String kid, URL x5u, Base64URL x5t, List<Base64> x5c) {
        if (kty == null) {
            throw new IllegalArgumentException("The key type \"kty\" must not be null");
        }
        this.kty = kty;
        this.use = use;
        this.alg = alg;
        this.kid = kid;
        this.x5u = x5u;
        this.x5t = x5t;
        this.x5c = x5c;
    }

    public KeyType getKeyType() {
        return this.kty;
    }

    public Use getKeyUse() {
        return this.use;
    }

    public Algorithm getAlgorithm() {
        return this.alg;
    }

    public String getKeyID() {
        return this.kid;
    }

    public URL getX509CertURL() {
        return this.x5u;
    }

    public Base64URL getX509CertThumbprint() {
        return this.x5t;
    }

    public List<Base64> getX509CertChain() {
        if (this.x5c == null) {
            return null;
        }
        return Collections.unmodifiableList(this.x5c);
    }

    public abstract boolean isPrivate();

    public abstract JWK toPublicJWK();

    public JSONObject toJSONObject() {
        JSONObject o = new JSONObject();
        o.put("kty", this.kty.getValue());
        if (this.use != null) {
            if (this.use == Use.SIGNATURE) {
                o.put("use", "sig");
            }
            if (this.use == Use.ENCRYPTION) {
                o.put("use", "enc");
            }
        }
        if (this.alg != null) {
            o.put("alg", this.alg.getName());
        }
        if (this.kid != null) {
            o.put("kid", this.kid);
        }
        if (this.x5u != null) {
            o.put("x5u", this.x5u.toString());
        }
        if (this.x5t != null) {
            o.put("x5t", this.x5t.toString());
        }
        if (this.x5c != null) {
            o.put("x5c", this.x5c);
        }
        return o;
    }

    @Override
    public String toJSONString() {
        return this.toJSONObject().toString();
    }

    public String toString() {
        return this.toJSONObject().toString();
    }

    public static JWK parse(String s) throws ParseException {
        return JWK.parse(JSONObjectUtils.parseJSONObject(s));
    }

    public static JWK parse(JSONObject jsonObject) throws ParseException {
        KeyType kty = KeyType.parse(JSONObjectUtils.getString(jsonObject, "kty"));
        if (kty == KeyType.EC) {
            return ECKey.parse(jsonObject);
        }
        if (kty == KeyType.RSA) {
            return RSAKey.parse(jsonObject);
        }
        if (kty == KeyType.OCT) {
            return OctetSequenceKey.parse(jsonObject);
        }
        throw new ParseException("Unsupported key type \"kty\" parameter: " + kty, 0);
    }

    static {
        ParameterList params = new ParameterList();
        params.set("charset", "UTF-8");
        MIME_TYPE = new ContentType("application", "jwk+json", params);
    }
}

