/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jwt.core.writer;

import com.atlassian.jwt.core.TimeUtil;
import com.atlassian.jwt.writer.JwtJsonBuilder;
import net.minidev.json.JSONObject;

public class JsonSmartJwtJsonBuilder
implements JwtJsonBuilder {
    private final JSONObject json = new JSONObject();

    public JsonSmartJwtJsonBuilder() {
        this.issuedAt(TimeUtil.currentTimeSeconds());
        this.expirationTime(TimeUtil.currentTimePlusNSeconds(180L));
    }

    @Override
    public JwtJsonBuilder audience(String aud) {
        this.json.put("aud", aud);
        return this;
    }

    @Override
    public JwtJsonBuilder expirationTime(long exp) {
        this.json.put("exp", exp);
        return this;
    }

    @Override
    public JwtJsonBuilder issuedAt(long iat) {
        this.json.put("iat", iat);
        return this;
    }

    @Override
    public JwtJsonBuilder issuer(String iss) {
        this.json.put("iss", iss);
        return this;
    }

    @Override
    public JwtJsonBuilder jwtId(String jti) {
        this.json.put("jti", jti);
        return this;
    }

    @Override
    public JwtJsonBuilder notBefore(long nbf) {
        this.json.put("nbf", nbf);
        return this;
    }

    @Override
    public JwtJsonBuilder subject(String sub) {
        this.json.put("sub", sub);
        return this;
    }

    @Override
    public JwtJsonBuilder type(String typ) {
        this.json.put("typ", typ);
        return this;
    }

    @Override
    public JwtJsonBuilder claim(String name, Object obj) {
        this.json.put(name, obj);
        return this;
    }

    @Override
    public String build() {
        return this.json.toString();
    }

    public String toString() {
        return this.json.toString();
    }
}

