package com.atlassian.jwt.core.reader;

import com.atlassian.jwt.core.Clock;
import com.atlassian.jwt.core.SystemClock;
import com.atlassian.jwt.exception.JwtMalformedSharedSecretException;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.crypto.MACVerifier;

public class NimbusMacJwtReader extends NimbusJwtReader
{
    public NimbusMacJwtReader(String sharedSecret)
    {
        this(sharedSecret, SystemClock.getInstance());
    }

    public NimbusMacJwtReader(String sharedSecret, Clock clock)
    {
        super(createMACVerifier(sharedSecret), clock);
    }

    private static MACVerifier createMACVerifier(String sharedSecret)
    {
        try
        {
            return new MACVerifier(sharedSecret);
        }
        catch (JOSEException e)
        {
            throw new JwtMalformedSharedSecretException("Failed to create MAC verifier with the provided secret key", e);
        }
    }
}
