/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jwt.core.keys;

import com.atlassian.jwt.exception.JwtCannotRetrieveKeyException;
import java.io.Reader;
import java.security.KeyFactory;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;

public class KeyUtils {
    public RSAPrivateKey readRsaPrivateKeyFromPem(Reader reader) throws JwtCannotRetrieveKeyException {
        PEMParser pemParser = new PEMParser(reader);
        try {
            RSAPrivateKey privateKey;
            Object object = pemParser.readObject();
            PEMKeyPair pemKeyPair = (PEMKeyPair)object;
            byte[] encodedPrivateKey = pemKeyPair.getPrivateKeyInfo().getEncoded();
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(encodedPrivateKey);
            RSAPrivateKey rSAPrivateKey = privateKey = (RSAPrivateKey)keyFactory.generatePrivate(privateKeySpec);
            return rSAPrivateKey;
        }
        catch (Exception e) {
            throw new JwtCannotRetrieveKeyException("Error reading private key", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
    }
}

