/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jwt.core.writer;

import com.atlassian.jwt.core.TimeUtil;
import com.atlassian.jwt.writer.JwtJsonBuilder;
import javax.annotation.Nonnull;
import net.minidev.json.JSONObject;

public class JsonSmartJwtJsonBuilder
implements JwtJsonBuilder {
    private final JSONObject json = new JSONObject();

    public JsonSmartJwtJsonBuilder() {
        this.issuedAt(TimeUtil.currentTimeSeconds());
        this.expirationTime(TimeUtil.currentTimePlusNSeconds(180L));
    }

    @Nonnull
    public JwtJsonBuilder audience(@Nonnull String aud) {
        this.json.put((Object)"aud", (Object)aud);
        return this;
    }

    @Nonnull
    public JwtJsonBuilder expirationTime(long exp) {
        this.json.put((Object)"exp", (Object)exp);
        return this;
    }

    @Nonnull
    public JwtJsonBuilder issuedAt(long iat) {
        this.json.put((Object)"iat", (Object)iat);
        return this;
    }

    @Nonnull
    public JwtJsonBuilder issuer(@Nonnull String iss) {
        this.json.put((Object)"iss", (Object)iss);
        return this;
    }

    @Nonnull
    public JwtJsonBuilder jwtId(@Nonnull String jti) {
        this.json.put((Object)"jti", (Object)jti);
        return this;
    }

    @Nonnull
    public JwtJsonBuilder notBefore(long nbf) {
        this.json.put((Object)"nbf", (Object)nbf);
        return this;
    }

    @Nonnull
    public JwtJsonBuilder subject(@Nonnull String sub) {
        this.json.put((Object)"sub", (Object)sub);
        return this;
    }

    @Nonnull
    public JwtJsonBuilder type(@Nonnull String typ) {
        this.json.put((Object)"typ", (Object)typ);
        return this;
    }

    @Nonnull
    public JwtJsonBuilder queryHash(@Nonnull String qsh) {
        this.json.put((Object)"qsh", (Object)qsh);
        return this;
    }

    @Nonnull
    public JwtJsonBuilder claim(@Nonnull String name, @Nonnull Object obj) {
        this.json.put((Object)name, obj);
        return this;
    }

    @Nonnull
    public String build() {
        return this.json.toString();
    }

    public String toString() {
        return this.json.toString();
    }
}

