/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jwt.core.reader;

import com.atlassian.jwt.VerifiedJwt;
import com.atlassian.jwt.core.Clock;
import com.atlassian.jwt.core.JwtConfiguration;
import com.atlassian.jwt.core.SimpleJwt;
import com.atlassian.jwt.core.SystemClock;
import com.atlassian.jwt.exception.JwtExpiredException;
import com.atlassian.jwt.exception.JwtInvalidClaimException;
import com.atlassian.jwt.exception.JwtParseException;
import com.atlassian.jwt.exception.JwtSignatureMismatchException;
import com.atlassian.jwt.exception.JwtVerificationException;
import com.atlassian.jwt.reader.JwtReader;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jwt.JWTClaimsSet;
import java.text.ParseException;
import java.util.Date;
import net.minidev.json.JSONObject;

public class NimbusJwtReader
implements JwtReader {
    private final JWSVerifier verifier;
    private final Clock clock;
    private final JwtConfiguration jwtConfiguration;

    public NimbusJwtReader(JWSVerifier verifier, JwtConfiguration jwtConfiguration) {
        this(verifier, jwtConfiguration, SystemClock.getInstance());
    }

    public NimbusJwtReader(JWSVerifier verifier, JwtConfiguration jwtConfiguration, Clock clock) {
        this.verifier = verifier;
        this.jwtConfiguration = jwtConfiguration;
        this.clock = clock;
    }

    public VerifiedJwt verify(String jwt) throws JwtParseException, JwtVerificationException {
        JWTClaimsSet claims;
        boolean verifiedSignature;
        JWSObject jwsObject;
        try {
            jwsObject = JWSObject.parse((String)jwt);
        }
        catch (ParseException e) {
            throw new JwtParseException((Exception)e);
        }
        try {
            verifiedSignature = jwsObject.verify(this.verifier);
        }
        catch (JOSEException e) {
            throw new JwtSignatureMismatchException((Exception)((Object)e));
        }
        if (!verifiedSignature) {
            throw new JwtSignatureMismatchException(jwt);
        }
        JSONObject jsonPayload = jwsObject.getPayload().toJSONObject();
        try {
            claims = JWTClaimsSet.parse((JSONObject)jsonPayload);
        }
        catch (ParseException e) {
            throw new JwtParseException((Exception)e);
        }
        if (claims.getIssueTime() == null || claims.getExpirationTime() == null) {
            throw new JwtInvalidClaimException("'exp' and 'iat' are required claims. Atlassian JWT does not allow JWTs with unlimited lifetimes.");
        }
        if (claims.getExpirationTime().getTime() - claims.getIssueTime().getTime() > this.jwtConfiguration.getMaxJwtLifetime()) {
            throw new JwtInvalidClaimException("The difference between 'exp' and 'iat' must be less than " + this.jwtConfiguration.getMaxJwtLifetime() + ".");
        }
        Date now = this.clock.now();
        if (claims.getExpirationTime().before(now)) {
            throw new JwtExpiredException(claims.getExpirationTime(), now);
        }
        return new SimpleJwt(claims.getIssuer(), claims.getSubject(), jsonPayload.toString());
    }
}

