/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jwt.core.reader;

import com.atlassian.jwt.Jwt;
import com.atlassian.jwt.core.Clock;
import com.atlassian.jwt.core.SimpleJwt;
import com.atlassian.jwt.exception.JwtExpiredException;
import com.atlassian.jwt.exception.JwtInvalidClaimException;
import com.atlassian.jwt.exception.JwtParseException;
import com.atlassian.jwt.exception.JwtSignatureMismatchException;
import com.atlassian.jwt.exception.JwtTooEarlyException;
import com.atlassian.jwt.exception.JwtVerificationException;
import com.atlassian.jwt.reader.JwtClaimVerifier;
import com.atlassian.jwt.reader.JwtReader;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jwt.JWTClaimsSet;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minidev.json.JSONObject;

public class NimbusJwtReader
implements JwtReader {
    private static final String UNEXPECTED_TYPE_MESSAGE_PREFIX = "Unexpected type of JSON object member with key ";
    private static final Set<String> NUMERIC_CLAIM_NAMES = new HashSet<String>(Arrays.asList("exp", "iat", "nbf"));
    private final JWSVerifier verifier;
    private final Clock clock;

    public NimbusJwtReader(JWSVerifier verifier, Clock clock) {
        this.verifier = verifier;
        this.clock = clock;
    }

    @Nonnull
    public Jwt read(@Nonnull String jwt, @Nonnull Map<String, ? extends JwtClaimVerifier> requiredClaims) throws JwtParseException, JwtVerificationException {
        JWTClaimsSet claims;
        boolean verifiedSignature;
        JWSObject jwsObject;
        try {
            jwsObject = JWSObject.parse((String)jwt);
        }
        catch (ParseException e) {
            throw new JwtParseException((Exception)e);
        }
        try {
            verifiedSignature = jwsObject.verify(this.verifier);
        }
        catch (JOSEException e) {
            throw new JwtSignatureMismatchException((Exception)((Object)e));
        }
        if (!verifiedSignature) {
            throw new JwtSignatureMismatchException(jwt);
        }
        JSONObject jsonPayload = jwsObject.getPayload().toJSONObject();
        try {
            claims = JWTClaimsSet.parse((JSONObject)jsonPayload);
        }
        catch (ParseException e) {
            if (e.getMessage().startsWith(UNEXPECTED_TYPE_MESSAGE_PREFIX)) {
                String claimName = e.getMessage().replace(UNEXPECTED_TYPE_MESSAGE_PREFIX, "").replaceAll("\"", "");
                if (NUMERIC_CLAIM_NAMES.contains(claimName)) {
                    throw new JwtInvalidClaimException(String.format("Expecting claim '%s' to be numeric but it is a string", claimName), (Throwable)e);
                }
                throw new JwtParseException("Perhaps a claim is of the wrong type (e.g. expecting integer but found string): " + e.getMessage(), (Throwable)e);
            }
            throw new JwtParseException((Exception)e);
        }
        if (claims.getIssueTime() == null || claims.getExpirationTime() == null) {
            throw new JwtInvalidClaimException("'exp' and 'iat' are required claims. Atlassian JWT does not allow JWTs with unlimited lifetimes.");
        }
        Date now = this.clock.now();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        calendar.add(13, -30);
        Date nowMinusLeeway = calendar.getTime();
        calendar.setTime(now);
        calendar.add(13, 30);
        Date nowPlusLeeway = calendar.getTime();
        if (null != claims.getNotBeforeTime()) {
            if (!claims.getExpirationTime().after(claims.getNotBeforeTime())) {
                throw new JwtInvalidClaimException(String.format("The expiration time must be after the not-before time but exp=%s and nbf=%s", claims.getExpirationTime(), claims.getNotBeforeTime()));
            }
            if (claims.getNotBeforeTime().after(nowPlusLeeway)) {
                throw new JwtTooEarlyException(claims.getNotBeforeTime(), now, 30);
            }
        }
        if (claims.getExpirationTime().before(nowMinusLeeway)) {
            throw new JwtExpiredException(claims.getExpirationTime(), now, 30);
        }
        for (Map.Entry<String, ? extends JwtClaimVerifier> requiredClaim : requiredClaims.entrySet()) {
            requiredClaim.getValue().verify(claims.getClaim(requiredClaim.getKey()));
        }
        return new SimpleJwt(claims.getIssuer(), claims.getSubject(), jsonPayload.toString());
    }
}

