/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jwt.core;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang.StringUtils;

public class JwtUtil {
    public static final String JWT_REQUEST_FLAG = "com.atlassian.jwt.is-jwt-request";
    public static final String AUTHORIZATION_HEADER = "Authorization";
    public static final String JWT_AUTH_HEADER_PREFIX = "JWT ";
    private static final String ENCODING = "UTF-8";
    public static final char QUERY_PARAMS_SEPARATOR = '&';

    public static boolean requestContainsJwt(HttpServletRequest request) {
        return JwtUtil.extractJwt(request) != null;
    }

    public static String extractJwt(HttpServletRequest request) {
        String jwt = JwtUtil.getJwtParameter(request);
        if (jwt == null) {
            jwt = JwtUtil.getJwtHeaderValue(request);
        }
        return jwt;
    }

    private static String getJwtParameter(HttpServletRequest request) {
        String jwtParam = request.getParameter("jwt");
        return StringUtils.isEmpty((String)jwtParam) ? null : jwtParam;
    }

    private static String getJwtHeaderValue(HttpServletRequest request) {
        Enumeration headers = request.getHeaders(AUTHORIZATION_HEADER);
        if (null != headers) {
            while (headers.hasMoreElements()) {
                String authzHeader = headers.nextElement().toString().trim();
                String first4Chars = authzHeader.substring(0, Math.min(4, authzHeader.length()));
                if (!JWT_AUTH_HEADER_PREFIX.equalsIgnoreCase(first4Chars)) continue;
                return authzHeader.substring(4);
            }
        }
        return null;
    }

    public static String percentEncode(String str) throws UnsupportedEncodingException {
        if (str == null) {
            return "";
        }
        return URLEncoder.encode(str, ENCODING).replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
    }

    public static String computeSha256Hash(String hashInput) throws NoSuchAlgorithmException {
        if (null == hashInput) {
            throw new IllegalArgumentException("hashInput cannot be null");
        }
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        byte[] hashInputBytes = hashInput.getBytes();
        digest.update(hashInputBytes, 0, hashInputBytes.length);
        return new String(Hex.encodeHex((byte[])digest.digest()));
    }
}

