/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.johnson.spring.lifecycle;

import com.atlassian.johnson.spring.lifecycle.LifecycleState;
import com.google.common.base.MoreObjects;
import javax.annotation.Nonnull;
import javax.servlet.ServletContext;

public class LifecycleUtils {
    private static final String ATTR_STATE = LifecycleState.class.getName() + ":Current";

    private LifecycleUtils() {
        throw new UnsupportedOperationException(this.getClass() + " is a utility class and should not be instantiated.");
    }

    @Nonnull
    public static LifecycleState getCurrentState(@Nonnull ServletContext servletContext) {
        LifecycleState state = (LifecycleState)((Object)servletContext.getAttribute(ATTR_STATE));
        return (LifecycleState)((Object)MoreObjects.firstNonNull((Object)((Object)state), (Object)((Object)LifecycleState.CREATED)));
    }

    public static boolean isStarting(@Nonnull ServletContext servletContext) {
        LifecycleState state = LifecycleUtils.getCurrentState(servletContext);
        return state == LifecycleState.CREATED || state == LifecycleState.STARTING;
    }

    public static void updateState(@Nonnull ServletContext servletContext, @Nonnull LifecycleState state) {
        servletContext.setAttribute(ATTR_STATE, (Object)state);
    }
}

