/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.johnson.spring.lifecycle;

import com.atlassian.johnson.Johnson;
import com.atlassian.johnson.config.JohnsonConfig;
import com.atlassian.johnson.spring.lifecycle.LifecycleState;
import com.atlassian.johnson.spring.lifecycle.LifecycleUtils;
import com.atlassian.johnson.spring.web.servlet.JohnsonDispatcherServlet;
import java.io.IOException;
import java.net.URLEncoder;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.DispatcherServlet;

public class LifecycleDispatcherServlet
extends HttpServlet {
    private static final String PROP_SYNCHRONOUS = "johnson.spring.lifecycle.synchronousStartup";
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private volatile DispatcherServlet delegate;
    private volatile Thread startup;

    public void destroy() {
        DispatcherServlet delegate;
        Thread startup = this.startup;
        if (startup != null) {
            if (startup.isAlive()) {
                startup.interrupt();
            }
            try {
                startup.join();
            }
            catch (InterruptedException e) {
                this.log.error("The SpringMVC startup thread could not be joined", (Throwable)e);
            }
        }
        if ((delegate = this.delegate) != null) {
            delegate.destroy();
        }
    }

    public void init() throws ServletException {
        Thread thread = new Thread(() -> {
            JohnsonDispatcherServlet servlet = new JohnsonDispatcherServlet(){

                @Override
                protected String getDefaultServletContextAttributeName() {
                    return WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE;
                }
            };
            LifecycleUtils.updateState(this.getServletContext(), LifecycleState.STARTING);
            try {
                servlet.init(this.getServletConfig());
                this.delegate = servlet;
                LifecycleUtils.updateState(this.getServletContext(), LifecycleState.STARTED);
            }
            catch (Exception e) {
                LifecycleUtils.updateState(this.getServletContext(), LifecycleState.FAILED);
                this.log.error("SpringMVC could not be started", (Throwable)e);
            }
            finally {
                this.startup = null;
            }
        });
        thread.setDaemon(true);
        thread.setName("spring-startup");
        this.startup = thread;
        this.startup.start();
        if (Boolean.getBoolean(PROP_SYNCHRONOUS)) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.log.warn("Interrupted while waiting for synchronous Spring startup to complete");
            }
        }
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        DispatcherServlet delegate = this.delegate;
        if (delegate == null) {
            JohnsonConfig config = Johnson.getConfig((ServletContext)this.getServletContext());
            String nextUrl = request.getRequestURI();
            if (request.getQueryString() != null && !request.getQueryString().isEmpty()) {
                nextUrl = nextUrl + "?" + request.getQueryString();
            }
            String redirectUrl = request.getContextPath() + config.getErrorPath() + "?next=" + URLEncoder.encode(nextUrl, "UTF-8");
            response.sendRedirect(redirectUrl);
        } else {
            delegate.service((ServletRequest)request, (ServletResponse)response);
        }
    }
}

