(function (Backbone) {
    /**
     * @name JIRA.WorkflowDesigner.InitialStatusView
     * @class The representation of the initial status ("Create") on the designer canvas.
     */
    Backbone.define("JIRA.WorkflowDesigner.InitialStatusView", JIRA.WorkflowDesigner.BaseStatusView.extend(
    /** @lends JIRA.WorkflowDesigner.InitialStatusView# */
    {
        /**
         * Creates the figure
         *
         * @returns {draw2d.shape.basic.Circle}
         * @private
         */
        _createFigure: function () {
            var figure, fill;

            figure = this._figure = new draw2d.shape.basic.Circle(30);
            figure.setBackgroundColor("#C0C0C0");
            figure.setStroke(0);
            figure.setSelectable(false);
            figure.snapToGeometry = true;

            fill = this._fill = new draw2d.shape.basic.Circle(30);
            fill.onMouseEnter = _.bind(this.trigger, this, "highlight");
            fill.onMouseLeave = _.bind(this.trigger, this, "unhighlight");
            fill.setBackgroundColor("#C0C0C0");
            fill.setStroke(0);

            figure.addFigure(fill, new draw2d.layout.locator.CenterLocator(figure));
            this._canvas.addFigure(figure);

            JIRA.WorkflowDesigner.Draw2DUtilities.setCursor(fill, "move");
            this._addPort();
            this._positionFigure();
            return figure;
        },

        /**
         * Adds a port to the figure
         *
         * @private
         */
        _addPort: function () {
            var direction = JIRA.WorkflowDesigner.Direction.DOWN,
                locator;

            this.port = this._createPort({
                connectionDirection: direction
            });

            locator = new JIRA.WorkflowDesigner.Layout.Locator.PositionOnParentBoundsLocator({
                parent: this._figure,
                side: direction,
                bias: 0.5
            });

            this._figure.addPort(this.port, locator);
        },

        /**
         * @returns {draw2d.geo.Rectangle} The view's bounding box.
         */
        getBoundingBox: function () {
            return this._figure.getBoundingBox();
        },

        /**
         * @return {draw2d.Port[]} The view's ports.
         */
        getPorts: function () {
            return [this.port];
        },

        /**
         * @return {boolean} Whether the view is selected.
         */
        isSelected: function () {
            return false;
        }
    }));
}(JIRA.WorkflowDesigner.Backbone));