(function (Backbone) {
    AJS.namespace("JIRA.WorkflowDesigner.PropertiesPanel.TransitionPropertiesView");

    /**
     * @class JIRA.WorkflowDesigner.PropertiesPanel.TransitionPropertiesView
     * @classdesc The content of the properties panel when a transition is selected.
     * @extends JIRA.WorkflowDesigner.PropertiesPanel
     */
    Backbone.define("JIRA.WorkflowDesigner.PropertiesPanel.TransitionPropertiesView", JIRA.WorkflowDesigner.PropertiesPanel.PropertiesView.extend(
    /** @lends JIRA.WorkflowDesigner.PropertiesPanel.TransitionPropertiesView# */
    {
        events: {
            "click .delete": "_destroy",
            "click .edit": "_edit"
        },

        template: JIRA.WorkflowDesigner.Templates.PropertiesPanel.transition,

        /**
         * @return {string} The query string common to all links.
         * @private
         */
        _getQueryString: function () {
            var isInitial = this._selectedView.model.isInitial(),
                isGlobal = this._selectedView.model.isGlobalTransition(),
                parameters;

            parameters = {
                workflowMode: this._workflowModel.get("draft") ? "draft" : "live",
                workflowName: this._workflowModel.get("name"),
                workflowTransition: this._selectedView.model.get("actionId")
            };

            if (!isInitial && !isGlobal) {
                parameters.workflowStep = this._selectedView.model.getSourceStepId();
            }

            return JIRA.WorkflowDesigner.BrowserUtilities.makeQueryString(parameters);
        },

        /**
         * @return {object} The data to pass to the view's template.
         */
        serializeData: function () {
            var PropertiesView = JIRA.WorkflowDesigner.PropertiesPanel.PropertiesView,
                templateData = PropertiesView.prototype.serializeData.apply(this);

            return _.extend(templateData, {
                isInitial: this._selectedView.model.isInitial(),
                queryString: this._getQueryString()
            });
        }
    },

    /** @lends JIRA.WorkflowDesigner.PropertiesPanel.StatusPropertiesView */
    {
        /**
         * @param {Backbone.View} view View to check.
         * @return {boolean} Whether `view` is a transition view.
         */
        canHandleView: function (view) {
            return view instanceof JIRA.WorkflowDesigner.GlobalTransitionView ||
                   view instanceof JIRA.WorkflowDesigner.TransitionView;
        }
    }));
}(JIRA.WorkflowDesigner.Backbone));