AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer");

module("JIRA.WorkflowDesigner.PropertiesPanel.PropertiesView", {
    /**
     * @returns {jQuery} A properties view description element.
     */
    makeDescription: function () {
        return jQuery(JIRA.WorkflowDesigner.Templates.PropertiesPanel.description({
            content: "Hello!"
        }));
    },

    setup: function () {
        this.propertiesView = new JIRA.WorkflowDesigner.PropertiesPanel.PropertiesView({});
        this.propertiesView.$el.appendTo("#qunit-fixture");
    }
});

test("applyDescriptionExpander() adds an expander to long descriptions", function () {
    var description = this.makeDescription().css("max-height", "1px");

    this.propertiesView.$el.append(description);
    this.propertiesView.applyDescriptionExpander();

    equal(description.css("min-height"), "1px", "The description has a minimum height");
    equal(description.find(".aui-expander-trigger").length, 1, "The expander trigger is present");
    ok(description.hasClass("aui-expander-content"), "The description has the expander class");
});

test("applyDescriptionExpander() removes the expander from short descriptions", function () {
    var description = this.makeDescription().css("max-height", "100px");

    this.propertiesView.$el.append(description);
    this.propertiesView.applyDescriptionExpander();

    equal(description.find(".aui-expander-trigger").length, 0, "The expander trigger is not present");
    ok(!description.hasClass("aui-expander-content"), "The description doesn't have the expander class");
});