AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:test-resources");
AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer");

module("JIRA.WorkflowDesigner.PropertiesPanel.PropertiesPanelView", {
    /**
     * Change the workflow model's selected view and assert that a given properties view is shown.
     *
     * @param {JIRA.WorkflowDesigner.PropertiesPanel.PropertiesView} selectedView The view to select.
     * @param {object} viewContainer The object containing the properties view.
     * @param {string} viewName The name of the properties view.
     */
    assertPropertiesView: function (selectedView, viewContainer, viewName) {
        var renderSpy = this.sandbox.spy(viewContainer[viewName].prototype, "render"),
            viewSpy = this.sandbox.spy(viewContainer, viewName);

        this.canvasModel.set("selectedView", selectedView);
        equal(viewSpy.callCount, 1, "A property view instance was created");
        equal(renderSpy.callCount, 1, "The view's render method was called");
        ok(this.propertiesPanelView.$el.has(renderSpy.returnValues[0].el).length,
            "The view's element was added to the properties panel");
    },

    /**
     * Create and return a properties panel view.
     *
     * @return {JIRA.WorkflowDesigner.PropertiesPanel.PropertiesPanelView} The view.
     */
    createPropertiesPanelView: function () {
        this.workflowModel = new JIRA.WorkflowDesigner.WorkflowModel();
        this.canvasModel = new JIRA.WorkflowDesigner.CanvasModel({}, {
            workflowModel: this.workflowModel
        });
        this.canvasView = JIRA.WorkflowDesigner.TestUtilities.testCanvasView({
            canvasModel: this.canvasModel,
            workflowModel: this.workflowModel
        });
        this.canvas = this.canvasView.canvas;

        return new JIRA.WorkflowDesigner.PropertiesPanel.PropertiesPanelView({
            canvasModel: this.canvasModel,
            container: this.container,
            workflowModel: this.workflowModel
        });
    },

    setup: function () {
        this.container = jQuery("#qunit-fixture");
        this.propertiesPanelView = this.createPropertiesPanelView();
        this.sandbox = sinon.sandbox.create();
    },

    teardown: function () {
        this.sandbox.restore();
    }
});

test("A TransitionPropertiesView is shown when a global transition is selected", function () {
    JIRA.WorkflowDesigner.TestUtilities.fakeTimer(function () {
        var targetView = this.canvasView.addStatus(this.workflowModel.addStatus({})),
            transitionView;

        transitionView = new JIRA.WorkflowDesigner.GlobalTransitionView({
            canvas: this.canvas,
            model: new JIRA.WorkflowDesigner.TransitionModel({
                source: new JIRA.WorkflowDesigner.StatusModel({stepId: 1})
            }),
            targetView: targetView,
            workflowModel: new JIRA.WorkflowDesigner.WorkflowModel()
        });

        this.assertPropertiesView(transitionView, JIRA.WorkflowDesigner.PropertiesPanel, "TransitionPropertiesView");
    }, this);
});

test("A TransitionPropertiesView is shown when a transition is selected", function () {
    var sourceView = this.canvasView.addStatus(this.workflowModel.addStatus({})),
        targetView = this.canvasView.addStatus(this.workflowModel.addStatus({})),
        transitionView,
        workflowModel = new JIRA.WorkflowDesigner.WorkflowModel();

    transitionView = new JIRA.WorkflowDesigner.TransitionView({
        canvas: this.canvas,
        canvasModel: new JIRA.WorkflowDesigner.CanvasModel({}, {
            workflowModel: workflowModel
        }),
        model: new JIRA.WorkflowDesigner.TransitionModel({
            source: new JIRA.WorkflowDesigner.StatusModel({stepId: 1})
        }),
        sourceView: sourceView,
        targetView: targetView,
        workflowModel: workflowModel
    });

    this.assertPropertiesView(transitionView, JIRA.WorkflowDesigner.PropertiesPanel, "TransitionPropertiesView");
});

test("No PropertiesView is shown when nothing is selected", function () {
    var initializeSpy;

    // Use a status view as our "initial" state
    this.canvasModel.set("selectedView", new JIRA.WorkflowDesigner.StatusView({
        canvas: this.canvas,
        model: new JIRA.WorkflowDesigner.StatusModel({}),
        workflowModel: new JIRA.WorkflowDesigner.WorkflowModel()
    }));

    initializeSpy = this.sandbox.spy(JIRA.WorkflowDesigner.PropertiesPanel.PropertiesView.prototype, "initialize");
    this.canvasModel.set("selectedView", null);
    equal(initializeSpy.callCount, 0, "No PropertiesView was created");
});

test("A StatusPropertiesView is shown when a status selected", function () {
    var statusView = new JIRA.WorkflowDesigner.StatusView({
        canvas: this.canvas,
        model: new JIRA.WorkflowDesigner.StatusModel({}),
        workflowModel: new JIRA.WorkflowDesigner.WorkflowModel()
    });

    this.assertPropertiesView(statusView, JIRA.WorkflowDesigner.PropertiesPanel, "StatusPropertiesView");
});

test("The view renders when the selected view changes", function () {
    var renderStub = this.sandbox.stub(JIRA.WorkflowDesigner.PropertiesPanel.PropertiesPanelView.prototype, "render");

    this.propertiesPanelView = this.createPropertiesPanelView();
    this.canvasModel.set("selectedView", {});
    equal(renderStub.callCount, 1, "render() was called");
});

test("It can create subclasses based on the selected view", function () {
    var canvas,
        create,
        globalTransitionView,
        statusView,
        transitionView;

    canvas = JIRA.WorkflowDesigner.TestUtilities.testDraw2DCanvas();
    statusView = new JIRA.WorkflowDesigner.StatusView({
        canvas: canvas,
        model: new JIRA.WorkflowDesigner.StatusModel(),
        workflowModel: this.workflowModel
    });
    transitionView = new JIRA.WorkflowDesigner.TransitionView({
        canvas: JIRA.WorkflowDesigner.TestUtilities.testDraw2DCanvas(),
        canvasModel: new JIRA.WorkflowDesigner.CanvasModel({}, {
            workflowModel: this.workflowModel
        }),
        immutable: false,
        model: new JIRA.WorkflowDesigner.TransitionModel(),
        sourceView: statusView,
        targetView: statusView,
        workflowModel: this.workflowModel
    });
    globalTransitionView = new JIRA.WorkflowDesigner.GlobalTransitionView({
        canvas: JIRA.WorkflowDesigner.TestUtilities.testDraw2DCanvas(),
        immutable: true,
        workflowModel: this.workflowModel,
        targetView: statusView
    });
    create = JIRA.WorkflowDesigner.PropertiesPanel.PropertiesPanelView.create;

    this.canvasModel.set("selectedView", transitionView, {silent: true});
    ok(create({canvasModel: this.canvasModel}) instanceof JIRA.WorkflowDesigner.PropertiesPanel.TransitionPropertiesView,
        "Can handle a transitions view");

    this.canvasModel.set("selectedView", globalTransitionView, {silent: true});
    ok(create({canvasModel: this.canvasModel}) instanceof JIRA.WorkflowDesigner.PropertiesPanel.TransitionPropertiesView,
        "Can handle a global transition view");

    this.canvasModel.set("selectedView", statusView, {silent: true});
    ok(create({canvasModel: this.canvasModel}) instanceof JIRA.WorkflowDesigner.PropertiesPanel.StatusPropertiesView,
        "Can handle a status view");
});

test("transaction:start/end events are forwarded from PropertiesViews", function () {
    var propertiesPanelView,
        propertiesView,
        statusPropertiesViewSpy = this.sandbox.spy(JIRA.WorkflowDesigner.PropertiesPanel, "StatusPropertiesView"),
        transactionEndSpy = sinon.spy(),
        transactionStartSpy = sinon.spy();

    propertiesPanelView = this.createPropertiesPanelView().render();
    this.canvasModel.set("selectedView", new JIRA.WorkflowDesigner.StatusView({
        canvas: this.canvas,
        model: new JIRA.WorkflowDesigner.StatusModel({}),
        workflowModel: this.workflowModel
    }));

    propertiesPanelView.on({
        "transaction:end": transactionEndSpy,
        "transaction:start": transactionStartSpy
    });

    propertiesView = statusPropertiesViewSpy.thisValues[0];
    propertiesView.trigger("transaction:start");
    equal(transactionStartSpy.callCount, 1, "The transaction:start event was forwarded");

    propertiesView.trigger("transaction:end");
    equal(transactionStartSpy.callCount, 1, "The transaction:end event was forwarded");
});