AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:test-resources");AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer");module("JIRA.WorkflowDesigner.ReuseTransitionFormView",{createView:function(B){var A;B=_.defaults({},B,{model:new JIRA.WorkflowDesigner.TransitionModel(),sourceStatuses:[{text:"Open",value:1}],targetStatuses:[{text:"Closed",value:2},{text:"Open",value:1}],workflowModel:this.createWorkflowModel()});A=new JIRA.WorkflowDesigner.ReuseTransitionFormView(B);this.sandbox.spy(A.model,"set");A.$el.appendTo("#qunit-fixture");A.render();A.onShow();return A},createViewWithNoTransitions:function(){var A;A=this.createWorkflowModel();A.get("transitions").reset();return this.createView({workflowModel:A})},createWorkflowModel:function(){var B,A;A=new JIRA.WorkflowDesigner.WorkflowModel({name:"Workflow"});B=A.get("statuses");B.add([{statusId:1,stepId:1},{statusId:2,stepId:2}]);A.get("transitions").add([{actionId:1,name:"Close",source:B.at(0),target:B.at(1)}]);return A},setup:function(){var A=this.sandbox=sinon.sandbox.create();this.addCommonTransitionDeferred=jQuery.Deferred();this.addCommonTransitionStub=A.stub(JIRA.WorkflowDesigner.IO.AJAX.WorkflowTransitionsAJAXManager,"addCommonTransition").returns(this.addCommonTransitionDeferred)},teardown:function(){this.sandbox.restore()}});test("Changing the target status updates the transition field",function(){var A;A=this.createView();ok(A.ui.noTransitionsMessage.is(":hidden"),'The "no transitions" message is hidden');A.ui.targetStepId.val("1");A.ui.targetStepId.trigger("selected");ok(A.ui.noTransitionsMessage.is(":visible"),'The "no transitions" message is visible')});test("Clears the transition's angles on status change",function(){var B,A;B={sourceAngle:null,targetAngle:null};A=this.createView();A.ui.sourceStepId.trigger("selected");ok(A.model.set.getCall(0).calledWithExactly(B),"The transition's angles were cleared after changing the source status");A.ui.targetStepId.trigger("selected");ok(A.model.set.getCall(0).calledWithExactly(B),"The transition's angles were cleared after changing the target status")});test("Common transitions are squashed in the transition field",function(){var B,A,C;C=this.createWorkflowModel();C.get("transitions").add({actionId:1,name:"Close",source:C.get("statuses").at(1),target:C.get("statuses").at(1)});A=this.createView({workflowModel:C});B=A.ui.transitionId.find("option");equal(B.length,1,"The transition field has one option");equal(B.text(),"Close","The option's text is correct");equal(B.val(),"1","The option's value is correct")});test("Lists transitions in alphabetical order",function(){var B,C,A,D;B=[{text:"Close",value:"1"},{text:"Stay Closed",value:"2"}];D=this.createWorkflowModel();D.get("transitions").add({actionId:2,name:"Stay Closed",source:D.get("statuses").at(1),target:D.get("statuses").at(1)});A=this.createView({workflowModel:D});C=A.ui.transitionId.find("option").map(function(){var E=jQuery(this);return{text:E.text(),value:E.val()}}).toArray();deepEqual(C,B,"The transitions are listed in alphabetical order")});test("Shows a message when there are no transitions to the selected target status",function(){var A=this.createViewWithNoTransitions();ok(A.$("#transition-id-single-select").is(":hidden"),"The transition ID field is not visible");ok(A.ui.noTransitionsMessage.is(":visible"),'The "no transitions" message is visible')});test("submit() rejects the returned deferred if there are no transitions to the target status",function(){var A=this.createViewWithNoTransitions().submit();equal(A.state(),"rejected","The returned promise was rejected")});test("submit() rejects the returned deferred on failure",function(){var A;A=this.createView().submit();this.addCommonTransitionDeferred.reject("Error");equal(A.state(),"rejected","The returned promise was rejected");A.fail(function(B){equal(B,"Error","It was rejected with the correct error message")})});test("submit() successfully reuses a transition",function(){var E,C,A,B,D;B=this.createView();D=B.options.workflowModel;this.sandbox.spy(JIRA.WorkflowDesigner.Analytics,"triggerAddCommonTransition");E={sourceStatusId:1,transitionId:1,workflowName:"Workflow"};C=D.get("transitions").at(0).omit("id","sourceAngle","targetAngle");C=_.extend(C,{source:D.get("statuses").at(0)});JIRA.WorkflowDesigner.TestUtilities.fill(B.el,{sourceStepId:1,targetStepId:2,transitionId:1});A=B.submit();equal(A.state(),"pending","The returned promise is pending");ok(this.addCommonTransitionStub.calledWithExactly(E),"WorkflowTransitionsAJAXManager.addCommonTransition was called with the correct arguments");this.addCommonTransitionDeferred.resolve();equal(A.state(),"resolved","The returned promise was resolved");equal(JIRA.WorkflowDesigner.Analytics.triggerAddCommonTransition.callCount,1,"An analytics event was triggered");ok(B.model.set.calledWithExactly(C),"The correct attributes were set on the TransitionModel")});test("The initial transition isn't shown in the transition field",function(){var A,B;B=this.createWorkflowModel();B.get("statuses").at(0).set("initial",true);A=this.createView({workflowModel:B});equal(A.ui.transitionId.find("option").length,0,"The transitions field contains no options")});test('Triggers a "createNewTransition" event when the create new transition link is clicked',function(){var B=sinon.spy(),A;A=this.createViewWithNoTransitions();A.on("createNewTransition",B);A.$(".create-new-transition").click();equal(B.callCount,1,"A createNewTransition event was triggered")});