AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:test-resources");AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer");module("JIRA.WorkflowDesigner.Dialogs.CreateStatusDialogView",{setup:function(){var A=this.sandbox=sinon.sandbox.create();this.createStatusStub=A.stub(JIRA.WorkflowDesigner.IO.AJAX.WorkflowStatusesAJAXManager,"createStatus");this.createStatusStub.returns(jQuery.Deferred().promise());this.workflowModel=new JIRA.WorkflowDesigner.WorkflowModel({name:"Workflow"})},showDialog:function(A){A=_.defaults({},A,{workflowModel:this.workflowModel,statusModel:new JIRA.WorkflowDesigner.StatusModel()});new JIRA.WorkflowDesigner.Dialogs.CreateStatusDialogView(A).show();return JIRA.Dialog.current&&JIRA.Dialog.current.get$popup()},teardown:function(){JIRA.WorkflowDesigner.TestUtilities.removeDialogs();this.sandbox.restore()}});test("An error message appears if creation fails",function(){var C=this.showDialog(),A,B="No status for you!";this.createStatusStub.returns(jQuery.Deferred().reject(B).promise());JIRA.WorkflowDesigner.TestUtilities.submit(C,{"#status-name":"Happy Little Status"});A=C.find(".aui-message.error");equal(A.length,1,"An error message is shown in the dialog");ok(A.text().indexOf(B)>-1,"It contains the correct text");equal(C.find(":disabled").length,0,"No inputs are disabled");this.createStatusStub.returns(jQuery.Deferred().promise());JIRA.WorkflowDesigner.TestUtilities.submit(C);equal(C.find(".error").length,0,"Errors are removed on submit")});test("Creating a status without a global transition",function(){var B=jQuery.Deferred(),D=this.showDialog(),A,C=this.sandbox.stub(this.workflowModel,"reset");this.createStatusStub.returns(B);this.sandbox.stub(JIRA.WorkflowDesigner.Analytics,"triggerAddStatus");this.sandbox.stub(JIRA.WorkflowDesigner.Analytics,"triggerAddStep");JIRA.WorkflowDesigner.TestUtilities.submit(D,{"#status-description":"This is a status description. How exciting.","#status-name":"Happy Little Status"});A={createGlobalTransition:false,description:"This is a status description. How exciting.",name:"Happy Little Status",statusCategoryId:undefined,workflowName:this.workflowModel.get("name")};equal(D.find(":input:disabled").length,D.find(":input").length,"All inputs are disabled while submitting");equal(this.createStatusStub.callCount,1,"StatusesAJAXManager.createStatus() was called");deepEqual(this.createStatusStub.args[0],[A],"It was passed the correct options");B.resolve({});ok(!JIRA.WorkflowDesigner.TestUtilities.dialogIsVisible(),"The dialog closes on success");equal(C.callCount,1,"WorkflowModel.reset() was called");deepEqual(C.args[0],[{}],"It was passed the correct data");ok(JIRA.WorkflowDesigner.Analytics.triggerAddStatus.calledOnce,"Analytics event for add/status has been triggered");ok(JIRA.WorkflowDesigner.Analytics.triggerAddStep.calledOnce,"Analytics event for add/step has been triggered")});test("The createGlobalTransition option is respected",function(){var A=this.showDialog({createGlobalTransition:true});equal(A.find("#create-global-transition-create").attr("checked"),"checked","The option was respected")});test('The "create global transition" checkbox is respected',function(){var A=this.showDialog(),B;this.createStatusStub.returns(jQuery.Deferred().promise());A.find("#create-global-transition-create").attr("checked","checked");JIRA.WorkflowDesigner.TestUtilities.submit(A,{"#status-description":"This is a status description. How exciting.","#status-name":"Happy Little Status"});B=[{createGlobalTransition:true,description:"This is a status description. How exciting.",name:"Happy Little Status",statusCategoryId:undefined,workflowName:this.workflowModel.get("name")}];equal(this.createStatusStub.callCount,1,"WorkflowStatusesAJAXManager.createStatus() was called");deepEqual(this.createStatusStub.args[0],B,"It was passed the correct arguments")});test("The selected status category is passed to WorkflowStatusesAJAXManager#createStatus",function(){this.sandbox.stub(JIRA.WorkflowDesigner.IO.AJAX.StatusCategoriesAJAXManager,"getStatusCategories").returns(jQuery.Deferred().resolve([{colorName:"green",id:3,key:"done",name:"Complete"}]));JIRA.WorkflowDesigner.TestUtilities.withDarkFeature("jira.issue.status.lozenge",true,function(){JIRA.WorkflowDesigner.TestUtilities.submit(this.showDialog(),{"#status-category-id":"3","#status-name":"Mean Green Status"});equal(this.createStatusStub.callCount,1,"WorkflowStatusesAJAXManager.createStatus() was called");equal(this.createStatusStub.args[0][0].statusCategoryId,"3","It was passed the correct status category ID")},this)});