(function (Backbone) {
    Backbone.define("JIRA.WorkflowDesigner.Dialogs.TransitionDialogView", JIRA.WorkflowDesigner.Dialogs.FormDialogView.extend(
    /** @lends JIRA.WorkflowDesigner.Dialogs.TransitionDialogView# */
    {
        /**
         * Initialise the view.
         *
         * @constructs
         * @classdesc
         * A dialog for creating/editing a transition.
         *
         * This view is abstract; do not create instances of it, use those that extend from it.
         * @extends JIRA.WorkflowDesigner.Dialogs.FormDialogView
         * @param {object} options
         * @param {JIRA.WorkflowDesigner.CanvasModel} options.canvasModel The application's `CanvasModel`.
         * @param {JIRA.WorkflowDesigner.TransitionModel} options.transitionModel The transition being created.
         * @param {JIRA.WorkflowDesigner.WorkflowModel} options.workflowModel The application's `WorkflowModel`.
         */
        initialize: function (options) {
            _.bindAll(this, "_onError", "_onLoadError", "_onSubmit", "_onSuccess");

            this._canvasModel = options.canvasModel;
            this._transitionModel = options.transitionModel;
            this._workflowModel = options.workflowModel;
        },

        /**
         * @returns {jQuery.Deferred} A deferred that is resolved with screen options.
         * @protected
         */
        _getScreenOptions: function () {
            var deferred = jQuery.Deferred(),
                request = JIRA.WorkflowDesigner.IO.AJAX.ScreensAJAXManager.getScreens(),
                selectedScreenId = this._transitionModel.get("screenId");

            function makeOption(object) {
                return {
                    text: object.name,
                    value: object.id,
                    selected: object.id === selectedScreenId
                };
            }

            request.done(function (screens) {
                deferred.resolve(_.map(screens, makeOption));
            });

            request.fail(deferred.reject);
            return deferred.promise();
        },

        /**
         * Display an error message and hide the dialog.
         *
         * Called when loading of the dialog's content fails.
         *
         * @param {string} errorMessage The error message to show.
         * @protected
         */
        _onLoadError: function (errorMessage) {
            JIRA.WorkflowDesigner.Messages.showErrorMessage(errorMessage);
            this.hide();
        },

        /**
         * @param {jQuery.Event} e Submit event
         * @private
         */
        _onSubmit: function (e) {
            e.preventDefault();
            this.disable();
            this.removeErrorMessages();
        }
    }));
}(JIRA.WorkflowDesigner.Backbone));