AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:test-resources");
AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer");

module("JIRA.WorkflowDesigner.Dialogs.InlineDialogView", {
    createDialog: function () {
        var View;

        View = JIRA.WorkflowDesigner.Dialogs.InlineDialogView.extend({
            _getContent: function (element, showDialog) {
                element.html("<input type='text'>");
                showDialog();
            }
        });

        return new View({
            trigger: jQuery("<div>")
        });
    },

    /**
     * Trigger a "keydown" event for the escape key.
     *
     * @param {element} [target=document] The target element.
     */
    pressEscape: function (target) {
        jQuery(target || document).trigger(jQuery.Event("keydown", {
            which: jQuery.ui.keyCode.ESCAPE
        }));
    },

    setup: function () {
        this.sandbox = sinon.sandbox.create();
    },

    teardown: function () {
        JIRA.WorkflowDesigner.TestUtilities.removeDialogs();
        this.sandbox.restore();
    }
});

test("hide()", function () {
    var dialog = this.createDialog();

    this.sandbox.stub(dialog._inlineDialog, "hide");
    dialog.hide();
    equal(dialog._inlineDialog.hide.callCount, 1, "The view's inline dialog was hidden");
});

test("_onBeforeShow()", function () {
    JIRA.WorkflowDesigner.TestUtilities.fakeTimer(function () {
        var dialog = this.createDialog();

        this.sandbox.spy(dialog, "_onBeforeShow");
        dialog.show();
        equal(dialog._onBeforeShow.callCount, 1, "The view's _onBeforeShow method was called");
    }, this);
});

asyncTest("_onShow()", function () {
    var deferred,
        dialog = this.createDialog();

    this.sandbox.spy(dialog, "_onShow");
    deferred = dialog.show();
    equal(dialog._onShow.callCount, 0, "The view's _onShow method hasn't been called");

    deferred.done(function () {
        equal(dialog._onShow.callCount, 1, "The view's _onShow method was called");
        start();
    });
});

asyncTest("Pressing escape closes the inline dialog", function () {
    var dialog = this.createDialog(),
        instance = this;

    sinon.spy(dialog, "hide");

    dialog.show().done(function () {
        instance.pressEscape();
        equal(dialog.hide.callCount, 1, "The view's hide method was called");

        start();
    });
});

asyncTest("Pressing escape doesn't close the inline dialog if an input has focus", function () {
    var dialog = this.createDialog(),
        instance = this;

    sinon.spy(dialog, "hide");

    dialog.show().done(function () {
        instance.pressEscape(dialog.$(":input"));
        equal(dialog.hide.callCount, 0, "The view's hide method wasn't called");

        start();
    });
});

asyncTest("show()", function () {
    var deferred,
        dialog = this.createDialog();

    this.sandbox.stub(dialog._inlineDialog, "show");
    deferred = dialog.show();
    equal(deferred.state(), "pending", "The returned deferred is pending");
    equal(dialog._inlineDialog.show.callCount, 1, "The view's inline dialog was shown");

    _.delay(function () {
        equal(deferred.state(), "resolved", "The returned deferred is resolved once the inline dialog becomes visible");
        start();
    }, AJS.InlineDialog.opts.fadeTime);
});