AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:test-resources");AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer");module("JIRA.WorkflowDesigner.Dialogs.EditStatusDialogView",{setup:function(){var B,A=this.sandbox=sinon.sandbox.create();B=jQuery.Deferred().resolve([{id:100,numberOfWorkflows:1}]);this.getAssociatedWorkflowsStub=A.stub(JIRA.WorkflowDesigner.IO.AJAX.StatusesAJAXManager,"getNumberOfAssociatedWorkflows").returns(5);this.getStatusesStub=A.stub(JIRA.WorkflowDesigner.IO.AJAX.StatusesAJAXManager,"getStatuses").returns(B);this.updateStatusStub=A.stub(JIRA.WorkflowDesigner.IO.AJAX.WorkflowStatusesAJAXManager,"updateStatus").returns(jQuery.Deferred())},showDialog:function(A){A=_.defaults({},A,{statusModel:new JIRA.WorkflowDesigner.StatusModel({statusCategory:{id:3},statusId:100,stepId:1,name:"Status",description:"This is the description."}),workflowModel:new JIRA.WorkflowDesigner.WorkflowModel({name:"Workflow Name"})});new JIRA.WorkflowDesigner.Dialogs.EditStatusDialogView(A).show();return JIRA.Dialog.current&&JIRA.Dialog.current.get$popup()},teardown:function(){JIRA.WorkflowDesigner.TestUtilities.removeDialogs();this.sandbox.restore()}});test("A warning is shown if the status is used in other workflows",function(){this.getStatusesStub.returns(jQuery.Deferred().resolve([{id:100}]));equal(this.showDialog().find(".aui-message.warning").length,1,"A warning is shown")});test("An error message is shown if editing the status fails",function(){var C=this.showDialog(),A,B="Oh noes!";this.updateStatusStub.returns(jQuery.Deferred().reject(B).promise());JIRA.WorkflowDesigner.TestUtilities.submit(C);A=C.find(".aui-message.error");equal(A.length,1,"An error message is shown in the dialog");ok(A.text().indexOf(B)>-1,"It contains the correct text");equal(C.find(":input:disabled").length,0,"No elements in the dialog are disabled");this.updateStatusStub.returns(jQuery.Deferred().promise());JIRA.WorkflowDesigner.TestUtilities.submit(C);equal(C.find(".error").length,0,"Errors are removed on submit")});test("An error message is shown if loading associated workflows fails",function(){var A="No associated workflows for you!",B=this.sandbox.stub(JIRA.WorkflowDesigner.Messages,"showErrorMessage");this.getAssociatedWorkflowsStub.returns(jQuery.Deferred().reject(A));this.showDialog();ok(!JIRA.WorkflowDesigner.TestUtilities.dialogIsVisible(),"The dialog was hidden");ok(B.calledWithExactly(A),"An error message was shown")});test("An error message is shown if loading statuses fails",function(){var A="No statuses for you!",B=this.sandbox.stub(JIRA.WorkflowDesigner.Messages,"showErrorMessage");this.getStatusesStub.returns(jQuery.Deferred().reject(A));this.showDialog();ok(!JIRA.WorkflowDesigner.TestUtilities.dialogIsVisible(),"The dialog was hidden");ok(B.calledWithExactly(A),"An error message was shown")});test("Editing a status",function(){var B=jQuery.Deferred(),D,C,E,A,F=this.sandbox.spy(JIRA.WorkflowDesigner,"StatusModel");D=this.showDialog();A=F.thisValues[0];this.updateStatusStub.returns(B.promise());this.sandbox.stub(JIRA.WorkflowDesigner.Analytics,"triggerUpdateStatus");this.sandbox.stub(JIRA.WorkflowDesigner.Analytics,"triggerUpdateStep");JIRA.WorkflowDesigner.TestUtilities.submit(D,{"#status-description":"Awesome new description!","#status-name":"New Name"});equal(D.find(":input:disabled").length,D.find(":input").length,"All inputs are disabled while submitting");equal(this.updateStatusStub.callCount,1,"WorkflowStatusesAJAXManager.updateStatus() was called");B.resolve();E=[{description:"Awesome new description!",name:"New Name",statusCategoryId:undefined,statusId:100,workflowName:"Workflow Name"}];C={description:"Awesome new description!",name:"New Name",statusCategory:null};deepEqual(this.updateStatusStub.args[0],E,"It was passed the correct arguments");deepEqual(_.pick(A.attributes,_.keys(C)),C,"The StatusModel's attributes were updated");ok(JIRA.WorkflowDesigner.Analytics.triggerUpdateStatus.calledOnce,"Analytics event for update/status has been triggered");ok(JIRA.WorkflowDesigner.Analytics.triggerUpdateStep.calledOnce,"Analytics event for udpate/step has been triggered")});test("Fields are populated with the status's attributes",function(){var A=this.showDialog();equal(A.find("#status-description").val(),"This is the description.","The status's description was used");equal(A.find("#status-name").val(),"Status","The status's name was used")});test("No warning is shown if the status isn't used in other workflows",function(){this.getAssociatedWorkflowsStub.returns(jQuery.Deferred().resolve(0));equal(this.showDialog().find(".aui-message.warning").length,0,"No warning is visible")});test("The selected status category is used",function(){var D,C=JIRA.WorkflowDesigner.IO.AJAX.StatusCategoriesAJAXManager,A,B=this.sandbox.spy(JIRA.WorkflowDesigner,"StatusModel");D=[{colorName:"blue-gray",id:2,key:"new",name:"New"},{colorName:"green",id:3,key:"done",name:"Complete"}];this.sandbox.stub(C,"getStatusCategories").returns(jQuery.Deferred().resolve(D));this.updateStatusStub.returns(jQuery.Deferred().resolve());JIRA.WorkflowDesigner.TestUtilities.withDarkFeature("jira.issue.status.lozenge",true,function(){JIRA.WorkflowDesigner.TestUtilities.submit(this.showDialog(),{"#status-category-id":"2"});equal(this.updateStatusStub.callCount,1,"WorkflowStatusesAJAXManager#updateStatus was called");equal(this.updateStatusStub.args[0][0].statusCategoryId,"2","It was passed the correct status category");A=B.thisValues[0];deepEqual(A.get("statusCategory"),{colourName:"blue-gray",id:2},"The StatusModel's statusCategory attribute was updated")},this)});