AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:test-resources");AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer");module("JIRA.WorkflowDesigner.Draw2DCanvas",{setup:function(){this.canvas=JIRA.WorkflowDesigner.TestUtilities.testDraw2DCanvas();this.singleSelectionPolicy=new draw2d.policy.canvas.SingleSelectionPolicy();this.canvas.installEditPolicy(this.singleSelectionPolicy);this.sandbox=sinon.sandbox.create();this.sandbox.stub(JIRA.WorkflowDesigner.BrowserUtilities,"getZoomLevel");this.sandbox.stub(JIRA.Messages,"showErrorMsg").returns({css:jQuery.noop,remove:jQuery.noop})},teardown:function(){this.sandbox.restore()}});test("createLayers()",function(){var B=JIRA.WorkflowDesigner.Draw2DCanvas.Layer,A;equal(this.canvas.getLayer("a"),undefined,"Layer a is undefined");this.canvas.createLayers("a");A=this.canvas.getLayer("a");ok(A instanceof B,"Layer a is defined");this.canvas.createLayers("a");ok(this.canvas.getLayer("a")===A,"Calling createLayers() is idempotent");equal(this.canvas.getLayer("b"),undefined,"Layer b is undefined");equal(this.canvas.getLayer("c"),undefined,"Layer c is undefined");this.canvas.createLayers("b","c");ok(this.canvas.getLayer("b") instanceof B,"Layer b is defined");ok(this.canvas.getLayer("c") instanceof B,"Layer c is defined")});test("Double clicks outside the canvas aren't observed",function(){var A=this.sandbox.stub(this.canvas,"onDoubleClick");this.canvas.fromDocumentToCanvasCoordinate=function(){return new draw2d.geo.Point(0,0)};jQuery(document).dblclick();equal(A.callCount,0,"The double click wasn't observed");this.canvas.html.dblclick();equal(A.callCount,1,"The double click was observed")});test("Dragging outside the container",function(){var B=sinon.spy(this.singleSelectionPolicy,"onMouseDown"),A=sinon.spy(this.singleSelectionPolicy,"onMouseDrag");this.canvas.html.trigger(jQuery.Event("mousedown",{clientX:0,clientY:0,which:0}));equal(B.callCount,1,"The mouse down event was handled");jQuery(document).trigger(jQuery.Event("mousemove",{clientX:0,clientY:0}));equal(A.callCount,1,"The mouse move event was handled")});test("fitToContainer()",function(){var A=sinon.stub(this.canvas.paper,"setSize");this.canvas.html.css({height:100,width:100});this.canvas.svgElement.attr({height:100,width:100});this.canvas.fitToContainer();equal(A.callCount,0,"Does nothing if the elements are the same size");this.canvas.html.css("height",200).hide();this.canvas.fitToContainer();equal(A.callCount,0,"Does nothing if the SVG element isn't visible");this.canvas.html.show();this.canvas.fitToContainer();equal(A.callCount,1,"Paper#setSize() was called to resize the SVG element");deepEqual(A.args[0],[100,200],"It was passed the correct arguments");equal(this.canvas.svgElement.css("height"),"200px","The SVG element's CSS height is correct");equal(this.canvas.svgElement.css("width"),"100px","The SVG element's CSS width is correct")});test("getLayer()",function(){var A;A=this.canvas.getLayer("layer");equal(A,undefined,"getLayer() returns undefined for unknown layers");this.canvas.createLayers("layer");A=this.canvas.getLayer("layer");ok(A instanceof JIRA.WorkflowDesigner.Draw2DCanvas.Layer,"getLayer() returns defined layers")});test("getSelectedFigure()",function(){var A=new draw2d.shape.basic.Rectangle();this.canvas.addFigure(A);equal(this.canvas.getSelectedFigure(),null,"The selected figure is initially null");this.singleSelectionPolicy.select(this.canvas,A);ok(this.canvas.getSelectedFigure()===A,"getSelectedFigure() returns the selected figure")});test("removeFigure() removes the figure from its layer",function(){var A=new draw2d.shape.basic.Rectangle(),B;this.canvas.createLayers("layer");B=this.canvas.getLayer("layer");B.addFigure(A);sinon.spy(B,"removeFigure");this.canvas.removeFigure(A);equal(B.removeFigure.callCount,1,"Layer#removeFigure() was called");ok(B.removeFigure.args[0][0]===A,"It was passed the correct figure")});test("Removing the currently hovered figure clears the currently hovered figure",function(){var A=new draw2d.shape.basic.Rectangle();this.canvas.addFigure(A);this.canvas.currentHoverFigure=A;this.canvas.removeFigure(A);equal(this.canvas.currentHoverFigure,null,"The currently hovered figure was cleared")});test("selectFigure()",function(){var A=new draw2d.shape.basic.Rectangle();this.canvas.addFigure(A);this.canvas.selectFigure(A);ok(this.canvas.getSelection().getPrimary()===A,"The figure was selected");this.canvas.selectFigure(null);equal(this.canvas.getSelection().getPrimary(),null,"The selection was cleared")});