(function () {
    AJS.namespace("JIRA.WorkflowDesigner.TriangleFigure");

    /**
     * @classdesc Renders a simple, left pointing, triangle figure
     * @class JIRA.WorkflowDesigner.TriangleFigure
     * @extends draw2d.VectorFigure
     */
    JIRA.WorkflowDesigner.TriangleFigure = draw2d.VectorFigure.extend(
    /** @lends JIRA.WorkflowDesigner.TriangleFigure#*/
    {
        /**
         * Repaints the figure
         *
         * @param {object} attributes
         */
        repaint: function(attributes) {
            var path;

            if (this.shape === null) {
                return;
            }

            path = [
                "M", this.getAbsoluteX(), this.getAbsoluteY() + this.getHeight() / 2, // start at the center left
                "l", this.getWidth(), -(this.getHeight()/2), //
                "l", 0, this.getHeight(),
                "Z"
            ].join(" ");

            this._super(_.extend({}, attributes, {
                path: path
            }));
        },

        /**
         * @returns {string} Path in SVG format
         */
        createShapeElement: function() {
            return this.canvas.paper.path("");
        }
    });
}());