(function (Backbone) {
    var frameHeight = 40,
        imageHeight = 440;

    Backbone.define("JIRA.WorkflowDesigner.ProgressIndicatorBlanketView", Backbone.Marionette.ItemView.extend(
    /** @lends JIRA.WorkflowDesigner.ProgressIndicatorBlanketView# */
    {
        className: "progress-indicator-blanket",

        template: JIRA.WorkflowDesigner.Templates.progressIndicatorBlanket,

        ui: {
            spinner: ".spinner"
        },

        /**
         * Initialise the view.
         *
         * @classdesc A semi-transparent blanket containing a progress indicator.
         * @constructs
         * @extends Backbone.Marionette.ItemView
         * @param {object} options
         * @param {element|string} options.container The container to show the view in.
         */
        initialize: function (options) {
            this._container = jQuery(options.container);
        },

        /**
         * Remove the view from its container.
         */
        hide: function () {
            clearInterval(this._intervalID);
            this.$el.remove();
        },

        /**
         * Show the view in its container.
         */
        show: function () {
            var currentOffset = 0,
                instance = this;

            function showNextFrame() {
                currentOffset = (currentOffset - frameHeight) % imageHeight;
                instance.ui.spinner.css("background-position", "0 " + currentOffset + "px");
            }

            clearInterval(this._intervalID);
            this._intervalID = setInterval(showNextFrame, 50);
            this.render().$el.appendTo(this._container);
        }
    }));
}(JIRA.WorkflowDesigner.Backbone));