AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer");

module("JIRA.WorkflowDesigner.LineStartResizeHandle");

test("getGap() gets the gap transformation from a GappedConnection", function () {
    var connection = new JIRA.WorkflowDesigner.Layout.Connection.GappedConnection(10),
        gap = {x: 10, y: 0},
        resizeHandle;

    sinon.stub(connection, "getStartPointGapTransformation").returns(gap);
    resizeHandle = new JIRA.WorkflowDesigner.LineStartResizeHandle(connection);

    deepEqual(resizeHandle.getGap(), gap);
});

test("getGap() returns null gap if the connection is not a GappedConnection", function () {
    var connection = new draw2d.Connection(),
        resizeHandle = new JIRA.WorkflowDesigner.LineStartResizeHandle(connection);

    deepEqual(resizeHandle.getGap(), {x: 0, y: 0});
});
