(function (Backbone) {
    Backbone.define("JIRA.WorkflowDesigner.Draw2DView", Backbone.View.extend({
        /**
         * Initialise the view.
         *
         * @classdesc A Backbone view with a Draw2D figure.
         * @constructs
         * @extends Backbone.View
         * @param {object} options
         * @param {draw2d.Canvas} options.canvas The Draw2D canvas to render to.
         */
        initialize: function (options) {
            this._canvas = options.canvas;
        },

        /**
         * Remove the view from the canvas.
         */
        remove: function () {
            Backbone.View.prototype.remove.apply(this, arguments);
            this._canvas.removeFigure(this._figure);
        }
    }));
}(JIRA.WorkflowDesigner.Backbone));