AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer");

module("Patch for draw2d.geo.Rectangle");

test("clone() should return a new Rectangle", function () {
    var original = new draw2d.geo.Rectangle(0, 0, 100, 100);
    var clone = original.clone();

    ok(original !== clone, "Rectangles are different objects");
    ok(original.equals(clone), "They have the same origin and dimensions");
});

test("scaleByFactor() should scale the Rectangle", function () {
    var original = new draw2d.geo.Rectangle(0, 0, 100, 100);

    deepEqual(original.clone().scaleByFactor(1).toJSON(),
        original.toJSON(),
        "Factor 1 does not change the size of the rectangle");

    deepEqual(original.clone().scaleByFactor(2).toJSON(),
        new draw2d.geo.Rectangle(-50, -50, 200, 200).toJSON(),
        "Factor 2 makes the Rectangle twice as big");

    deepEqual(original.clone().scaleByFactor(0.5).toJSON(),
        new draw2d.geo.Rectangle(25, 25, 50, 50).toJSON(),
        "Factor 0.5 makes the Rectangle twice as small");
});

test("getRelativePosition()", function () {
    var rectangle, point;

    rectangle = new draw2d.geo.Rectangle(0, 0, 100, 100);
    point = new draw2d.geo.Point(0, 0);
    deepEqual(rectangle.getRelativePosition(point).getComponents(), [0, 0], "Point at rectangle's origin");

    rectangle = new draw2d.geo.Rectangle(0, 0, 100, 100);
    point = new draw2d.geo.Point(25, 25);
    deepEqual(rectangle.getRelativePosition(point).getComponents(), [25, 25], "Point inside rectangle");

    rectangle = new draw2d.geo.Rectangle(0, 0, 100, 100);
    point = new draw2d.geo.Point(101, -1);
    deepEqual(rectangle.getRelativePosition(point).getComponents(), [101, -1], "Point outside rectangle");
});

test("getRelativePositionAsPercentage()", function () {
    var rectangle, point;

    rectangle = new draw2d.geo.Rectangle(0, 0, 100, 100);
    point = new draw2d.geo.Point(0, 0);
    deepEqual(rectangle.getRelativePositionAsPercentage(point).getComponents(), [0, 0], "Point at rectangle's origin");

    rectangle = new draw2d.geo.Rectangle(0, 0, 100, 100);
    point = new draw2d.geo.Point(25, 25);
    deepEqual(rectangle.getRelativePositionAsPercentage(point).getComponents(), [0.25, 0.25], "Point inside rectangle");

    rectangle = new draw2d.geo.Rectangle(0, 0, 100, 100);
    point = new draw2d.geo.Point(101, -1);
    deepEqual(rectangle.getRelativePositionAsPercentage(point).getComponents(), [1.01, -0.01], "Point outside rectangle");
});