(function () {
    _.extend(draw2d.Figure.prototype, {
        /**
         * Send the figure to the back of the canvas.
         *
         * @return {draw2d.Figure} <tt>this</tt>
         */
        sendToBack: function () {
            this.svgNodes && this.svgNodes.toBack();
            this.shape && this.shape.toBack();
            return this;
        },

        /**
         * Send the figure to the front of the canvas.
         *
         * @return {draw2d.Figure} <tt>this</tt>
         */
        sendToFront: function () {
            this.shape && this.shape.toFront();
            this.svgNodes && this.svgNodes.toFront();
            return this;
        }
    });
}());