(function () {
    /**
     * Shortcut to draw2d.geo.Point
     *
     * @inner
     * @type {function}
     */
    var Point = draw2d.geo.Point;

    AJS.namespace("JIRA.WorkflowDesigner.Vector2D");

    JIRA.WorkflowDesigner.Vector2D = Point.extend(
    /** @lends JIRA.WorkflowDesigner.Vector2D# */
    {
        /**
         * Initialise the vector.
         *
         * Vectors may be initialised with either their start and end points or their x and y components.
         *
         * @clasdesc A 2D vector.
         * @extends draw2d.geo.Point
         * @constructs
         * @param {draw2d.geo.Point|number} a Either the vector's starting point or its x component.
         * @param {draw2d.geo.Point|number} b Either the vector's end point or its y component.
         */
        init: function (a, b) {
            var arePoints = a instanceof Point && b instanceof Point,
                x = a,
                y = b;

            if (arePoints) {
                x = b.x - a.x;
                y = b.y - a.y;
            }

            this._super(x, y);
        },

        /**
         * @return {number} The vector's length (magnitude).
         */
        getLength: function () {
            return Math.sqrt(Math.pow(this.x, 2) + Math.pow(this.y, 2));
        },

        /**
         * Perform scalar multiplication on the vector.
         *
         * @param {number} value The value to multiply by.
         * @return {JIRA.WorkflowDesigner.Vector2D} <tt>this</tt>
         */
        multiply: function (value) {
            this.x *= value;
            this.y *= value;
            return this;
        },

        /**
         * Normalize the vector such that its magnitude is 1, but its direction is unchanged.
         *
         * Attempting to normalise the zero vector does nothing.
         *
         * @return {JIRA.WorkflowDesigner.Vector2D} <tt>this</tt>
         */
        normalize: function () {
            var length = this.getLength();
            if (length > 0) {
                this.multiply(1 / length);
            }

            return this;
        }
    });
}());