AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer");

module("JIRA.WorkflowDesigner.BrowserUtilities");

test("escapeQueryParameter()", function () {
    var actual = JIRA.WorkflowDesigner.BrowserUtilities.escapeQueryParameter("a 1&/=!'()*"),
        expected = "a+1%26%2F%3D%21%27%28%29%2A";

    equal(actual, expected, "The string was escaped correctly");
});

test("makeQueryString()", function () {
    var tests = [
        [{}, ""],
        [{a: 0}, "a=0"],
        [{a: 0, b: 1}, "a=0&b=1"],
        [{q: "Hello, world!"}, "q=Hello%2C+world%21"],
        [{'key name': 0}, "key+name=0"]
    ];

    _.each(tests, function (test, index) {
        var actual = JIRA.WorkflowDesigner.BrowserUtilities.makeQueryString(test[0]);
        equal(actual, test[1], "The correct value was returned for object " + index);
    });
});