(function () {
    AJS.namespace("JIRA.WorkflowDesigner.Policy.Feedback.StatusPortsFeedbackPolicy");

    /**
     * @class JIRA.WorkflowDesigner.Policy.Feedback.StatusPortsFeedbackPolicy
     * @classdesc Drag and drop feedback policy used for status ports.
     * @extends draw2d.policy.port.IntrusivePortsFeedbackPolicy
     */
    JIRA.WorkflowDesigner.Policy.Feedback.StatusPortsFeedbackPolicy = draw2d.policy.port.IntrusivePortsFeedbackPolicy.extend(
    /** @lends JIRA.WorkflowDesigner.Policy.Feedback.StatusPortsFeedbackPolicy.prototype */
    {
        /**
         * This method is called when a status port enters drag and drop and gets the list of all its drop target ports.
         * It can change the appearance of drop targets of otherwise prepare them for starting drag and drop.
         * Current implementation makes targets visible.
         *
         * @param {draw2d.util.ArrayList} dropTargets List of drop target ports.
         */
        prepareDropTargetsForDrag: function (dropTargets) {
            _.invoke(dropTargets.asArray(), "show");
        },

        /**
         * Don't change the drop target port appearance during dragging.
         *
         * @method
         */
        alterDropTargetOnDrag: jQuery.noop,

        /**
         * Don't change the drop target port appearance upon dropping.
         *
         * @method
         */
        alterDropTargetOnDragEnd: jQuery.noop,

        /**
         * Gets the color used for the connection line.
         *
         * @return {string} The colour to use for connection lines.
         */
        getConnectionLineColour: function () {
            return "#1a8cff";
        },

        /**
         * This method is called when the mouse enters the area of the port.
         *
         * Just set the glow on the port, don't change the connectionLine.
         *
         * @param {draw2d.Canvas} canvas Canvas element.
         * @param {draw2d.Figure} draggedFigure Figure being dragged.
         * @param {draw2d.Figure} hoverFigure Figure that is being hovered.
         */
        onHoverEnter: function (canvas, draggedFigure, hoverFigure) {
            hoverFigure.setGlow(true);
        },

        /**
         * This method is called when the mouse leaves the area of the port.
         *
         * Just remove the glow from the port, don't change the connectionLine.
         *
         * @param {draw2d.Canvas} canvas Canvas element.
         * @param {draw2d.Figure} draggedFigure Figure being dragged.
         * @param {draw2d.Figure} hoverFigure Figure that is being un-hovered.
         */
        onHoverLeave: function (canvas, draggedFigure, hoverFigure) {
            hoverFigure.setGlow(false);
        }
    });
}());