(function () {
    AJS.namespace("JIRA.WorkflowDesigner.Policy.Feedback.LineSelectionFeedbackPolicy");

    /**
     * @class JIRA.WorkflowDesigner.Policy.Feedback.LineSelectionFeedbackPolicy
     * @extends draw2d.policy.figure.LineSelectionFeedbackPolicy
     */
    JIRA.WorkflowDesigner.Policy.Feedback.LineSelectionFeedbackPolicy = draw2d.policy.figure.LineSelectionFeedbackPolicy.extend(
    /** @lends JIRA.WorkflowDesigner.Policy.Feedback.LineSelectionFeedbackPolicy# */
    {
        /**
         * Creates the ResizeHandle for the start of the connection
         *
         * @param {draw2d.Figure} figure
         * @returns {JIRA.WorkflowDesigner.LineStartResizeHandle}
         */
        createLineStartResizeHandle: function(figure) {
            return new JIRA.WorkflowDesigner.LineStartResizeHandle(figure);
        },

        /**
         * Creates the ResizeHandle for the end of the connection
         *
         * @param {draw2d.Figure} figure
         * @returns {JIRA.WorkflowDesigner.LineEndResizeHandle}
         */
        createLineEndResizeHandle: function(figure) {
            return new JIRA.WorkflowDesigner.LineEndResizeHandle(figure);
        }
    });
}());