(function () {
    AJS.namespace("JIRA.WorkflowDesigner.Policy.Canvas.SnapToGeometry.SnapPoints");

    /**
     * Extracts figure snap points.
     *
     * @namespace
     */
    JIRA.WorkflowDesigner.Policy.Canvas.SnapToGeometry.SnapPoints = {
        /**
         * @param {draw2d.Figure|draw2d.Figure[]} figures One or more Draw2D figures.
         * @return {object[]} The given figures' snap points on the x axis.
         */
        getXSnapPoints: function (figures) {
            function getSnapPoints(figure) {
                var boundingBox = figure.getBoundingBox();

                return _.map([
                    boundingBox.getLeft(),
                    boundingBox.getCenter().getX(),
                    boundingBox.getRight()
                ], this._makeSnapPoint(figure));
            }

            // Convert figures to an array if necessary.
            _.isArray(figures) || (figures = [figures]);
            return _.flatMap(figures, getSnapPoints, this);
        },

        /**
         * @param {draw2d.Figure|draw2d.Figure[]} figures One or more Draw2d figures.
         * @return {object[]} The given figures' snap points on the y axis.
         */
        getYSnapPoints: function (figures) {
            function getSnapPoints(figure) {
                var boundingBox = figure.getBoundingBox();

                return _.map([
                    boundingBox.getTop(),
                    boundingBox.getBottom()
                ], this._makeSnapPoint(figure));
            }

            // Convert figures to an array if necessary.
            _.isArray(figures) || (figures = [figures]);
            return _.flatMap(figures, getSnapPoints, this);
        },

        /**
         * @param {draw2d.Figure} figure A Draw2D figure.
         * @return {function} A function that creates snap points for <tt>figure</tt>.
         * @private
         */
        _makeSnapPoint: function (figure) {
            return function (value) {
                return {
                    rectangle: figure.getBoundingBox(),
                    value: value
                };
            };
        }
    };

    // Bind the object's functions so they can call each other.
    _.bindAll(JIRA.WorkflowDesigner.Policy.Canvas.SnapToGeometry.SnapPoints, "getXSnapPoints", "getYSnapPoints");
}());