AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:test-resources");
AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer");

module("JIRA.WorkflowDesigner.Policy.Canvas.SnapToGeometry.SnapEditPolicy", {
    addFigure: function (x, y, width, height) {
        var figure;

        figure = new draw2d.shape.basic.Rectangle(width, height);
        figure.snapToGeometry = true;

        this.canvas.addFigure(figure, x, y);
        return figure;
    },

    assertSnap: function (bounds, expected) {
        var result;

        // Position and size the drag figure, creating it if necessary.
        this.dragFigure || (this.dragFigure = this.addFigure.apply(this, bounds));
        this.dragFigure.setDimension(bounds[2], bounds[3]);
        this.dragFigure.setPosition(bounds[0], bounds[1]);
        this.dragFigure.isInDragDrop = true;

        expected = new draw2d.geo.Point(expected[0], expected[1]);
        result = this.editPolicy.snap(this.canvas, this.dragFigure, this.dragFigure.getPosition());
        ok(expected.equals(result), this.pointString(result) + " equals " + this.pointString(expected));
    },

    pointString: function (point) {
        return "(" + point.getX() + ", " + point.getY() + ")";
    },

    setup: function () {
        this.canvas = JIRA.WorkflowDesigner.TestUtilities.testDraw2DCanvas();
        this.editPolicy = new JIRA.WorkflowDesigner.Policy.Canvas.SnapToGeometry.SnapEditPolicy();
        this.canvas.installEditPolicy(this.editPolicy);
    }
});

test("snap()", function () {
    var tests = [
        [[ 0,  0, 10, 10], [ 0,  0]], // Aligned on both axes
        [[ 5,  0, 20, 10], [ 5,  0]],
        [[10, 20, 10, 20], [10, 20]],
        [[20, 10, 20, 20], [20, 10]],
        [[ 4,  0, 10, 10], [ 5,  0]], // Aligned on one axis, snap on the other
        [[ 0,  9, 10, 20], [ 0, 10]],
        [[21, 20, 10, 10], [20, 20]],
        [[15, 21, 10, 10], [15, 20]],
        [[ 1,  1, 10, 10], [ 0,  0]], // Snap on both axes
        [[16, 21, 10, 20], [15, 20]],
        [[21,  1, 10, 10], [20,  0]],
        [[ 6, 21, 20, 20], [ 5, 20]],
        [[16, 30, 10, 10], [15, 30]], // Over the threshold on one axis, snap on the other
        [[30,  9, 10, 10], [30, 10]],
        [[30,  1, 10, 20], [30,  0]],
        [[30, 30, 10, 10], [30, 30]]  // Over the threshold on both axes
    ];

    this.addFigure(10, 10, 10, 10);

    _.each(tests, function (test) {
        this.assertSnap(test[0], test[1]);
    }, this);
});

test("snap() ignores figures that haven't opted in", function () {
    var point = new draw2d.geo.Point(0, 0),
        result = this.editPolicy.snap(this.canvas, {}, point);

    ok(point === result, "snap() returned the figure's original position");
});