AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:test-resources");AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer");module("JIRA.WorkflowDesigner.IO.AJAX.WorkflowStatusesAJAXManager",{setup:function(){this.addStatusURL=AJS.contextPath()+"/rest/workflowDesigner/latest/workflows/statuses";this.createStatusURL=AJS.contextPath()+"/rest/workflowDesigner/latest/workflows/statuses/create";this.sandbox=sinon.sandbox.create({useFakeServer:true});this.workflowDataReaderStub=this.sandbox.stub(JIRA.WorkflowDesigner.IO.WorkflowDataReader,"read");this.workflowStatusesAJAXManager=JIRA.WorkflowDesigner.IO.AJAX.WorkflowStatusesAJAXManager},teardown:function(){this.sandbox.restore()}});test("addStatus()",function(){var C,D,B,A={};C=this.workflowStatusesAJAXManager.addStatus({createGlobalTransition:true,statusId:"Open",workflowName:"Workflow"});this.workflowDataReaderStub.returns(A);this.sandbox.server.respondWith(this.addStatusURL,[200,{},"{}"]);this.sandbox.server.respond();B={createGlobalTransition:"true",statusId:"Open",workflowName:"Workflow"};D=JIRA.WorkflowDesigner.TestUtilities.getRequestBodyAsObject(this.sandbox.server.requests[0].requestBody);deepEqual(D,B,"The request's body was correct");equal(this.workflowDataReaderStub.callCount,1,"The AJAX response was passed to WorkflowDataReader.read()");deepEqual(this.workflowDataReaderStub.args[0],[{}],"It was passed the correct arguments");equal(C.state(),"resolved","The returned deferred was resolved.");C.done(function(E){ok(E===A,"It was resolved with the output of WorkflowDataReader.read()")})});test("addStatus() rejects the returned deferred on error",function(){var A;A=this.workflowStatusesAJAXManager.addStatus({createGlobalTransition:true,statusId:"Closed",workflowName:"Workflow"});this.sandbox.server.respondWith(this.addStatusURL,[400,{},"No deal."]);this.sandbox.server.respond();equal(A.state(),"rejected","The returned deferred was rejected");A.fail(function(B){equal(B,"No deal.","It was rejected with the error message.")})});test("createStatus() with create global transition flag",function(){var D,C,B={},E,A=this.sandbox.spy(JIRA.WorkflowDesigner.IO.AJAX.StatusesAJAXManager,"reset");this.sandbox.server.respondWith(AJS.contextPath()+"/rest/workflowDesigner/latest/workflows/statuses",[200,{},""]);this.sandbox.server.respond();D=this.workflowStatusesAJAXManager.createStatus({createGlobalTransition:true,description:"Description",name:"Status",statusCategoryId:"1",workflowName:"Workflow"});this.workflowDataReaderStub.returns(B);this.sandbox.server.respondWith(this.createStatusURL,[200,{},"{}"]);this.sandbox.server.respond();E=JIRA.WorkflowDesigner.TestUtilities.getRequestBodyAsObject(this.sandbox.server.requests[0].requestBody);C={createGlobalTransition:"true",description:"Description",name:"Status",statusCategoryId:"1",workflowName:"Workflow"};deepEqual(E,C,"The request body for create was correct.");equal(this.workflowDataReaderStub.callCount,1,"The AJAX response was passed to WorkflowDataReader.read()");deepEqual(this.workflowDataReaderStub.args[0],[{}],"It was passed the correct arguments");equal(D.state(),"resolved","The returned deferred was resolved.");equal(A.callCount,1,"StatusesAJAXManager.reset() was called");D.done(function(F){ok(F===B,"It was resolved with the output of WorkflowDataReader.read()")})});test("createStatus() rejects the returned deferred on error",function(){var A;A=this.workflowStatusesAJAXManager.createStatus({description:"A plain old status.",name:"Status",workflowName:"Workflow"});this.sandbox.server.respondWith(this.createStatusURL,[400,{},"No"]);this.sandbox.server.respond();equal(A.state(),"rejected","The returned deferred was rejected");A.fail(function(B){equal(B,"No","It was rejected with the error message")})});test("removeStatus() resolves deferred result on success and has correct request body",function(){var B,A,C;B=this.workflowStatusesAJAXManager.removeStatus({statusId:100,workflowName:"Workflow"});this.sandbox.server.respondWith(AJS.contextPath()+"/rest/workflowDesigner/latest/workflows/statuses",[200,{},""]);this.sandbox.server.respond();A={statusId:"100",workflowName:"Workflow"};C=JIRA.WorkflowDesigner.TestUtilities.getRequestBodyAsObject(this.sandbox.server.requests[0].requestBody);deepEqual(C,A,"The request body matches the arguments sent to identify a status for removal");equal(B.state(),"resolved","The returned deferred was resolved.")});test("removeStatus() rejects the returned deferred on error",function(){var A;A=this.workflowStatusesAJAXManager.removeStatus({statusId:100,workflowName:"Workflow"});JIRA.WorkflowDesigner.TestUtilities.respondWithErrorAndAssertRejected(A,"/rest/workflowDesigner/latest/workflows/statuses",this.sandbox.server)});test("updateStatus() resolves deferred result on success",function(){var C,A,B;B={description:"New description!",name:"New Name",statusCategoryId:"1",statusId:"100",workflowName:"Workflow"};A=this.workflowStatusesAJAXManager.updateStatus({description:"New description!",name:"New Name",someUnknownParameter:true,statusCategoryId:"1",statusId:"100",workflowName:"Workflow"});this.sandbox.server.respondWith(AJS.contextPath()+"/rest/workflowDesigner/latest/workflows/statuses",[200,{},""]);this.sandbox.server.respond();C=JIRA.WorkflowDesigner.TestUtilities.getRequestBodyAsObject(this.sandbox.server.requests[0].requestBody);deepEqual(C,B,"The request body for update was correct.");equal(A.state(),"resolved","The returned deferred was resolved.")});test("updateStatus() rejects the returned deferred on error",function(){var A=this.workflowStatusesAJAXManager.updateStatus({transitionId:100,name:"name",description:"description",workflowName:"Workflow"});JIRA.WorkflowDesigner.TestUtilities.respondWithErrorAndAssertRejected(A,"/rest/workflowDesigner/latest/workflows/statuses",this.sandbox.server)});