AJS.test.require("com.atlassian.jira.dev.func-test-plugin:sinon");
AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer");

module("JIRA.WorkflowDesigner.IO.AJAX.StatusesAJAXManager", {
    setup: function () {
        this.server = sinon.fakeServer.create();
        this.statusesAJAXManager = JIRA.WorkflowDesigner.IO.AJAX.StatusesAJAXManager;
    },

    teardown: function () {
        this.server.restore();
        this.statusesAJAXManager.reset();
    }
});

test("getStatuses()", function () {
    var deferred = this.statusesAJAXManager.getStatuses(),
        response = [{name: "Open"}, {name: "Closed"}],
        URL = AJS.contextPath() + "/rest/workflowDesigner/latest/statuses";

    this.server.respondWith(new RegExp(URL), JSON.stringify(response));
    this.server.respond();

    equal(this.server.requests.length, 1, "An AJAX request was made to retrieve the statuses");
    equal(deferred.state(), "resolved", "The returned deferred was resolved");
    deferred.done(function (statuses) {
        deepEqual(statuses, response, "It was resolved with status information");
    });

    // The response should be cached.
    deferred = this.statusesAJAXManager.getStatuses();

    equal(this.server.requests.length, 1, "Subsequent calls don't result in an AJAX request");
    equal(deferred.state(), "resolved", "The returned deferred is resolved immediately");
    deferred.done(function (statuses) {
        deepEqual(statuses, response, "It is resolved with status information");
    });

    // Calling reset() should clear the cache.
    this.statusesAJAXManager.reset();
    deferred = this.statusesAJAXManager.getStatuses();
    this.server.respond();

    equal(this.server.requests.length, 2, "reset() clears the cached response");
    equal(deferred.state(), "resolved", "The returned deferred was resolved");
});

test("getStatuses() rejects the returned deferred on error", function () {
    var deferred = this.statusesAJAXManager.getStatuses(),
            URL = AJS.contextPath() + "/rest/workflowDesigner/latest/statuses";

    this.server.respondWith(new RegExp(URL), [400, {}, "No deal."]);
    this.server.respond();

    equal(deferred.state(), "rejected", "The returned deferred was rejected");
    deferred.fail(function (errorMessage) {
        equal(errorMessage, "No deal.", "It was rejected with the error message.");
    });
});

test("getNumberOfAssociatedWorkflows() returns the number of associated workflows()", function () {
    var deferred = this.statusesAJAXManager.getNumberOfAssociatedWorkflows("1"),
        response = 5,
        URL = AJS.contextPath() + "/rest/workflowDesigner/latest/statuses/associatedWorkflowCount";

    this.server.respondWith(new RegExp(URL), JSON.stringify(response));
    this.server.respond();

    equal(this.server.requests.length, 1, "An AJAX request was made to retrieve the statuses");
    equal(deferred.state(), "resolved", "The returned deferred was resolved");
    deferred.done(function (numberOfWorkflows) {
        equal(numberOfWorkflows, response, "It was resolved with the number of workflows");
    });
});

test("getNumberOfAssociatedWorkflows() rejects the returned deferred on error", function () {
    var deferred = this.statusesAJAXManager.getNumberOfAssociatedWorkflows("1"),
        URL = AJS.contextPath() + "/rest/workflowDesigner/latest/statuses/associatedWorkflowCount";

    this.server.respondWith(new RegExp(URL), [400, {}, "No deal."]);
    this.server.respond();

    equal(deferred.state(), "rejected", "The returned deferred was rejected");
    deferred.fail(function (errorMessage) {
        equal(errorMessage, "No deal.", "It was rejected with the error message.");
    });
});