(function () {
    AJS.namespace("JIRA.WorkflowDesigner.IO.AJAX.AJAXManager");

    /**
     * The base AJAX manager object.
     *
     * @namespace
     */
    JIRA.WorkflowDesigner.IO.AJAX.AJAXManager = {
        /**
         * Make an AJAX request.
         *
         * Attaches a CSRF token to the request and handles WebSudo.
         *
         * @param {object} options Options to pass to `jQuery.ajax()`.
         * @protected
         */
        _makeRequest: function (options) {
            var deferred = jQuery.Deferred(),
                request;

            options.headers = _.extend({}, options.headers, {
                "X-Atlassian-Token": "nocheck"
            });

            request = JIRA.SmartAjax.makeWebSudoRequest(options, {
                cancel: function (e) {
                    // Rejection must be deferred to ensure that the WebSudo
                    // dialog has closed and the original one is restored.
                    _.defer(deferred.reject, undefined, "abort");
                    e.preventDefault();
                }
            });

            request.done(deferred.resolve);
            request.fail(deferred.reject);
            return deferred.promise();
        }
    };
}());