(function () {
    /**
     * @inner
     * @param {JIRA.WorkflowDesigner.TransitionModel} transitionModel
     * @returns {Object}
     */
    function getTransitionJSON(transitionModel) {
        var extension,
            isGlobalTransition = transitionModel.get("globalTransition"),
            source = transitionModel.get("source"),
            target = transitionModel.get("target");

        extension = {
            sourceId: isGlobalTransition ? target.id : source.id,
            targetId: target.id
        };

        return _.chain(transitionModel.toJSON())
            .extend(extension)
            .omit("id", "source", "target")
            .value();
    }

    AJS.namespace("JIRA.WorkflowDesigner.IO.WorkflowDataWriter");

    /**
     * Writes workflow data to JSON.
     *
     * @namespace
     */
    JIRA.WorkflowDesigner.IO.WorkflowDataWriter = {
        /**
         * Write workflow data to JSON.
         *
         * @param {JIRA.WorkflowDesigner.WorkflowModel} workflowModel The workflow.
         * @return {object} The result of serializing <tt>workflowModel</tt> to JSON.
         */
        write: function (workflowModel) {
            var extension = {
                layout: {
                    statuses: workflowModel.get("statuses").invoke("toJSON"),
                    transitions: workflowModel.get("transitions").map(getTransitionJSON)
                }
            };

            return _.chain(workflowModel.toJSON())
                    .extend(extension)
                    .omit("currentStepId", "updateAuthor", "updatedDate", "liveStepIds", "loadedAt", "statuses", "transitions")
                    .value();
        }
    };
}());