AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:test-resources");AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer");module("JIRA.WorkflowDesigner.Application",{setup:function(){this.sandbox=sinon.sandbox.create();this.canvas=JIRA.WorkflowDesigner.TestUtilities.testCanvas();this.loadWorkflowStub=this.sandbox.stub(JIRA.WorkflowDesigner.IO.AJAX.WorkflowAJAXManager,"load");this.publishStub=this.sandbox.stub(JIRA.WorkflowDesigner.IO.AJAX.WorkflowAJAXManager,"publish");this.discardStub=this.sandbox.stub(JIRA.WorkflowDesigner.IO.AJAX.WorkflowAJAXManager,"discard");this.sandbox.stub(JIRA.WorkflowDesigner,"Canvas").returns(this.canvas);this.workflowModelResetSpy=this.sandbox.spy(JIRA.WorkflowDesigner.WorkflowModel.prototype,"reset")},teardown:function(){this.sandbox.restore()}});test("A global message is shown on error",function(){var B="No!",A=this.sandbox.stub(JIRA.WorkflowDesigner.Messages,"showErrorMessage");this.loadWorkflowStub.returns(jQuery.Deferred().reject(B));new JIRA.WorkflowDesigner.Application({workflowId:"Workflow"});equal(A.callCount,1,"JIRA.WorkflowDesigner.Messages.showErrorMessage was called");deepEqual(A.args[0],[B],"It was passed the correct arguments")});test("A warning is shown in unsupported browsers",function(){var B=jQuery("#qunit-fixture"),A=this.sandbox.stub(JIRA.WorkflowDesigner,"browserIsSupported").returns(false),C=this.sandbox.spy(JIRA.WorkflowDesigner.Templates,"browserNotSupportedWarning");new JIRA.WorkflowDesigner.Application({element:B});equal(JIRA.WorkflowDesigner.Canvas.callCount,0,"No JIRA.WorkflowDesigner.Canvas was created");equal(A.callCount,1,"JIRA.WorkflowDesigner.browserIsSupported was called");equal(C.callCount,1,"JIRA.WorkflowDesigner.Templates.browserNotSupportWarning was called");equal(B.find(".aui-message.warning").length,1,"The warning was appended to the application's element")});test("destroy() calls LayoutAutoSaver#destroy",function(){var A=this.sandbox.spy(JIRA.WorkflowDesigner.IO.LayoutAutoSaver.prototype,"destroy");new JIRA.WorkflowDesigner.Application().destroy();equal(A.callCount,1,"LayoutAutoSaver#destroy was called")});test("destroy() doesn't throw an exception in unsupported browsers",function(){var A;expect(0);this.sandbox.stub(JIRA.WorkflowDesigner,"browserIsSupported").returns(false);A=new JIRA.WorkflowDesigner.Application({element:jQuery("#qunit-fixture")});A.destroy()});test("Passing layout data to the constructor",function(){new JIRA.WorkflowDesigner.Application({layoutData:{}});equal(this.workflowModelResetSpy.callCount,1,"The Application's WorkflowModel was reset")});test("Supports loading a workflow by ID",function(){var A=jQuery.Deferred(),B=new JIRA.WorkflowDesigner.WorkflowModel();sinon.spy(this.canvas,"autoFit");sinon.spy(this.canvas,"hideProgressIndicator");sinon.spy(this.canvas,"showProgressIndicator");this.loadWorkflowStub.returns(A.promise());this.sandbox.stub(JIRA.WorkflowDesigner,"WorkflowModel").returns(B);new JIRA.WorkflowDesigner.Application({workflowId:"Workflow"});equal(this.loadWorkflowStub.callCount,1,"WorkflowAJAXManager#load() was called");deepEqual(this.loadWorkflowStub.args[0],["Workflow",false],"It was passed the correct arguments");equal(this.canvas.showProgressIndicator.callCount,1,"Canvas#showProgressIndicator() was called");A.resolve({});equal(this.canvas.autoFit.callCount,1,"Canvas#autoFit() was called");equal(this.canvas.hideProgressIndicator.callCount,1,"Canvas#hideProgressIndicator() was called");equal(this.workflowModelResetSpy.callCount,1,"WorkflowModel#reset() was called");deepEqual(this.workflowModelResetSpy.args[0],[{}],"It was passed the correct arguments");ok(B.has("loadedAt"),"WorkflowModel's loadedAt property was set");ok(B.get("loadedAt") instanceof Date,"It is a Date object");ok(new Date()-B.get("loadedAt")<500,"It is the current time")});test("The current step ID, if given, is passed to WorkflowModel",function(){this.workflowModelSpy=this.sandbox.spy(JIRA.WorkflowDesigner,"WorkflowModel");new JIRA.WorkflowDesigner.Application({currentStepId:42});equal(this.workflowModelSpy.args[0][0].currentStepId,42,"The current step ID was passed to the WorkflowModel constructor")});test('Triggers a "loaded" event after successfully loading a workflow via AJAX',function(){var B,A=jQuery.Deferred(),C=sinon.spy();this.loadWorkflowStub.returns(A.promise());B=new JIRA.WorkflowDesigner.Application({workflowId:"Workflow"});B.on("loaded",C);A.resolve({});equal(C.callCount,1,'A "loaded" event was triggered')});test('Triggers a "loaded" event after successfully loading the given workflow data',function(){var A=this.sandbox.spy(JIRA.WorkflowDesigner.Application.prototype,"trigger");new JIRA.WorkflowDesigner.Application({layoutData:{}});ok(A.calledWithExactly("loaded"),'A "loaded" event was triggered')});test("publishDraft() successfully publishes draft",function(){var C=new JIRA.WorkflowDesigner.Application({workflowId:"Workflow"}),E,A=jQuery.Deferred(),F=jQuery.Deferred().resolve(),D=new JIRA.WorkflowDesigner.WorkflowModel(),B=this.sandbox.stub(JIRA.WorkflowDesigner.Messages,"showErrorMessage"),G=this.sandbox.stub(JIRA.WorkflowDesigner.Application.prototype,"_loadWorkflow");sinon.spy(this.canvas,"hideProgressIndicator");sinon.spy(this.canvas,"showProgressIndicator");this.publishStub.returns(A.promise());G.returns(F);this.sandbox.stub(JIRA.WorkflowDesigner,"WorkflowModel").returns(D);E=C.publishDraft();equal(this.canvas.showProgressIndicator.callCount,1,"Canvas#showProgressIndicator() was called");equal(E.state(),"pending","The returned deferred is pending");equal(this.publishStub.callCount,1,"WorkflowAJAXManager#publish() was called");A.resolve();equal(E.state(),"resolved","The returned deferred is resolved on success");equal(this.canvas.hideProgressIndicator.callCount,0,"Canvas#hideProgressIndicator() was not called");equal(B.callCount,0,"JIRA.WorkflowDesigner.Messages.showErrorMessage was not called");equal(G.callCount,1,"Workflow designer was reloaded")});test("publishDraft() without reloadDesigner flag successfully publishes draft",function(){var C=new JIRA.WorkflowDesigner.Application({workflowId:"Workflow"}),E,A=jQuery.Deferred(),D=new JIRA.WorkflowDesigner.WorkflowModel(),B=this.sandbox.stub(JIRA.WorkflowDesigner.Messages,"showErrorMessage"),F=this.sandbox.stub(JIRA.WorkflowDesigner.Application.prototype,"_loadWorkflow");sinon.spy(this.canvas,"hideProgressIndicator");sinon.spy(this.canvas,"showProgressIndicator");this.publishStub.returns(A.promise());this.sandbox.stub(JIRA.WorkflowDesigner,"WorkflowModel").returns(D);E=C.publishDraft({reloadDesigner:false});equal(this.canvas.showProgressIndicator.callCount,1,"Canvas#showProgressIndicator() was called");equal(E.state(),"pending","The returned deferred is pending");equal(this.publishStub.callCount,1,"WorkflowAJAXManager#publish() was called");A.resolve();equal(E.state(),"resolved","The returned deferred is resolved on success");equal(this.canvas.hideProgressIndicator.callCount,0,"Canvas#hideProgressIndicator() was not called");equal(B.callCount,0,"JIRA.WorkflowDesigner.Messages.showErrorMessage was not called");equal(F.callCount,0,"Workflow designer was not reloaded")});test("publishDraft() fails publishing draft",function(){var C=new JIRA.WorkflowDesigner.Application({workflowId:"Workflow"}),E,A=jQuery.Deferred(),D=new JIRA.WorkflowDesigner.WorkflowModel(),B=this.sandbox.stub(JIRA.WorkflowDesigner.Messages,"showErrorMessage");sinon.spy(this.canvas,"hideProgressIndicator");sinon.spy(this.canvas,"showProgressIndicator");this.publishStub.returns(A.promise());this.sandbox.stub(JIRA.WorkflowDesigner,"WorkflowModel").returns(D);E=C.publishDraft();equal(E.state(),"pending","The returned deferred is pending");equal(this.publishStub.callCount,1,"WorkflowAJAXManager#publish() was called");equal(this.canvas.showProgressIndicator.callCount,1,"Canvas#showProgressIndicator() was called");A.reject("error message");equal(E.state(),"rejected","The returned deferred is rejected on failure");equal(this.canvas.hideProgressIndicator.callCount,1,"Canvas#hideProgressIndicator() was called");equal(B.callCount,1,"JIRA.WorkflowDesigner.Messages.showErrorMessage was called")});test("discardDraft() successfully discards draft",function(){var C=new JIRA.WorkflowDesigner.Application({workflowId:"Workflow"}),E,A=jQuery.Deferred(),D=new JIRA.WorkflowDesigner.WorkflowModel(),B=this.sandbox.stub(JIRA.WorkflowDesigner.Messages,"showErrorMessage"),F=this.sandbox.stub(JIRA.WorkflowDesigner.Application.prototype,"_loadWorkflow");sinon.spy(this.canvas,"hideProgressIndicator");sinon.spy(this.canvas,"showProgressIndicator");this.discardStub.returns(A.promise());F.returns(jQuery.Deferred().resolve());this.sandbox.stub(JIRA.WorkflowDesigner,"WorkflowModel").returns(D);E=C.discardDraft();equal(E.state(),"pending","The returned deferred is pending");equal(this.canvas.showProgressIndicator.callCount,1,"Canvas#showProgressIndicator() was called");equal(this.discardStub.callCount,1,"WorkflowAJAXManager#discard() was called");A.resolve();equal(E.state(),"resolved","The returned deferred is resolved on success");equal(this.canvas.hideProgressIndicator.callCount,0,"Canvas#hideProgressIndicator() was not called");equal(B.callCount,0,"JIRA.WorkflowDesigner.Messages.showErrorMessage was not called");equal(this.discardStub.callCount,1,"WorkflowAJAXManager#discard() was called");equal(F.callCount,1,"Workflow designer was reloaded")});test("discardDraft() without reloadDesigner flag successfully discards draft",function(){var C=new JIRA.WorkflowDesigner.Application({workflowId:"Workflow"}),E,A=jQuery.Deferred(),D=new JIRA.WorkflowDesigner.WorkflowModel(),B=this.sandbox.stub(JIRA.WorkflowDesigner.Messages,"showErrorMessage"),F=this.sandbox.stub(JIRA.WorkflowDesigner.Application.prototype,"_loadWorkflow");sinon.spy(this.canvas,"hideProgressIndicator");sinon.spy(this.canvas,"showProgressIndicator");this.discardStub.returns(A.promise());F.returns(jQuery.Deferred().resolve());this.sandbox.stub(JIRA.WorkflowDesigner,"WorkflowModel").returns(D);E=C.discardDraft({reloadDesigner:false});equal(E.state(),"pending","The returned deferred is pending");equal(this.canvas.showProgressIndicator.callCount,1,"Canvas#showProgressIndicator() was called");equal(this.discardStub.callCount,1,"WorkflowAJAXManager#discard() was called");A.resolve();equal(E.state(),"resolved","The returned deferred is resolved on success");equal(this.canvas.hideProgressIndicator.callCount,0,"Canvas#hideProgressIndicator() was not called");equal(B.callCount,0,"JIRA.WorkflowDesigner.Messages.showErrorMessage was not called");equal(F.callCount,0,"Workflow designer was not reloaded")});test("discardDraft() fails discarding draft",function(){var C=new JIRA.WorkflowDesigner.Application({workflowId:"Workflow"}),E,A=jQuery.Deferred(),D=new JIRA.WorkflowDesigner.WorkflowModel(),B=this.sandbox.stub(JIRA.WorkflowDesigner.Messages,"showErrorMessage");sinon.spy(this.canvas,"hideProgressIndicator");sinon.spy(this.canvas,"showProgressIndicator");this.discardStub.returns(A.promise());this.sandbox.stub(JIRA.WorkflowDesigner,"WorkflowModel").returns(D);E=C.discardDraft();equal(E.state(),"pending","The returned deferred is pending");equal(this.canvas.showProgressIndicator.callCount,1,"Canvas#showProgressIndicator() was called");A.reject("error message");equal(E.state(),"rejected","The returned deferred is rejected on failure");equal(this.canvas.hideProgressIndicator.callCount,1,"Canvas#hideProgressIndicator() was called");equal(B.callCount,1,"JIRA.WorkflowDesigner.Messages.showErrorMessage was called")});