/*
 * Decompiled with CFR 0.152.
 */
package com.sysbliss.jira.plugins.workflow.manager;

import com.atlassian.jira.workflow.JiraWorkflow;
import com.sysbliss.jira.plugins.workflow.manager.WorkflowAnnotationManager;
import com.sysbliss.jira.plugins.workflow.model.WorkflowAnnotation;
import com.sysbliss.jira.plugins.workflow.model.layout.serialize.JSONAnnotationSerializer;
import com.sysbliss.jira.plugins.workflow.util.WorkflowDesignerPropertySet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class WorkflowAnnotationManagerImpl
implements WorkflowAnnotationManager {
    private WorkflowDesignerPropertySet workflowDesignerPropertySet;

    public WorkflowAnnotationManagerImpl(WorkflowDesignerPropertySet workflowDesignerPropertySet) {
        this.workflowDesignerPropertySet = workflowDesignerPropertySet;
    }

    @Override
    public List<WorkflowAnnotation> getAnnotationsForWorkflow(JiraWorkflow workflow) throws Exception {
        return this.loadAnnotations(this.getPropertyKey(workflow));
    }

    @Override
    public void addAnnotationToWorkflow(JiraWorkflow workflow, WorkflowAnnotation annotation) throws Exception {
        String propKey = this.getPropertyKey(workflow);
        List<WorkflowAnnotation> annotations = this.loadAnnotations(propKey);
        WorkflowAnnotation oldAnnotation = this.findAnnotationById(annotations, annotation.getId());
        if (oldAnnotation == null) {
            annotations.add(annotation);
        }
        this.saveAnnotations(propKey, annotations);
    }

    @Override
    public void removeAnnotationFromWorkflow(JiraWorkflow workflow, String annotationId) throws Exception {
        String propKey = this.getPropertyKey(workflow);
        List<WorkflowAnnotation> annotations = this.loadAnnotations(propKey);
        Iterator<WorkflowAnnotation> i = annotations.iterator();
        while (i.hasNext()) {
            WorkflowAnnotation annotation = i.next();
            if (!annotation.getId().equals(annotationId)) continue;
            i.remove();
        }
        this.saveAnnotations(propKey, annotations);
    }

    @Override
    public void removeAnnotationFromWorkflow(JiraWorkflow workflow, WorkflowAnnotation annotation) throws Exception {
        this.removeAnnotationFromWorkflow(workflow, annotation.getId());
    }

    @Override
    public boolean workflowHasAnnotation(JiraWorkflow workflow, String annotationId) throws Exception {
        String propKey = this.getPropertyKey(workflow);
        List<WorkflowAnnotation> annotations = this.loadAnnotations(propKey);
        return this.findAnnotationById(annotations, annotationId) != null;
    }

    @Override
    public boolean workflowHasAnnotation(JiraWorkflow workflow, WorkflowAnnotation annotation) throws Exception {
        return this.workflowHasAnnotation(workflow, annotation.getId());
    }

    @Override
    public void copyAnnotationsForDraftWorkflow(String parentWorkflowName) throws Exception {
        String originalPropKey = "jira.jwd.annotation:".concat(parentWorkflowName);
        String originalJson = this.workflowDesignerPropertySet.getProperty(originalPropKey);
        if (StringUtils.isNotBlank((String)originalJson)) {
            String propKey = "jira.jwd.draft.annotation:".concat(parentWorkflowName);
            this.workflowDesignerPropertySet.setProperty(propKey, originalJson);
        }
    }

    @Override
    public void copyActiveAnnotations(String originalWorkflowName, String newWorkflowName) throws Exception {
        String originalPropKey = "jira.jwd.annotation:".concat(originalWorkflowName);
        String originalJson = this.workflowDesignerPropertySet.getProperty(originalPropKey);
        if (StringUtils.isNotBlank((String)originalJson)) {
            String propKey = "jira.jwd.annotation:".concat(newWorkflowName);
            this.workflowDesignerPropertySet.setProperty(propKey, originalJson);
        }
    }

    @Override
    public void publishDraftAnnotations(String parentWorkflowName) throws Exception {
        String originalPropKey = "jira.jwd.draft.annotation:".concat(parentWorkflowName);
        String originalJson = this.workflowDesignerPropertySet.getProperty(originalPropKey);
        if (StringUtils.isNotBlank((String)originalJson)) {
            String propKey = "jira.jwd.annotation:".concat(parentWorkflowName);
            this.workflowDesignerPropertySet.setProperty(propKey, originalJson);
        }
    }

    @Override
    public void updateAnnotationForWorkflow(JiraWorkflow workflow, WorkflowAnnotation annotation) throws Exception {
        String propKey = this.getPropertyKey(workflow);
        List<WorkflowAnnotation> annotations = this.loadAnnotations(propKey);
        WorkflowAnnotation oldAnnotation = this.findAnnotationById(annotations, annotation.getId());
        if (oldAnnotation != null) {
            oldAnnotation.setDescription(annotation.getDescription());
        }
        this.saveAnnotations(propKey, annotations);
    }

    private List<WorkflowAnnotation> loadAnnotations(String propKey) throws IOException {
        List<WorkflowAnnotation> annotations = new ArrayList<WorkflowAnnotation>();
        String json = this.workflowDesignerPropertySet.getProperty(propKey);
        if (!StringUtils.isBlank((String)json)) {
            JSONAnnotationSerializer deserializer = new JSONAnnotationSerializer();
            annotations = deserializer.deserialize(json);
        }
        return annotations;
    }

    private WorkflowAnnotation findAnnotationById(List<WorkflowAnnotation> annotations, String idToFind) {
        WorkflowAnnotation found = null;
        for (WorkflowAnnotation annotation : annotations) {
            if (!annotation.getId().equals(idToFind)) continue;
            found = annotation;
            break;
        }
        return found;
    }

    private String getPropertyKey(JiraWorkflow workflow) {
        String propKey = workflow.isDraftWorkflow() ? "jira.jwd.draft.annotation:".concat(workflow.getName()) : "jira.jwd.annotation:".concat(workflow.getName());
        return propKey;
    }

    private void saveAnnotations(String propKey, List<WorkflowAnnotation> annotations) throws Exception {
        JSONAnnotationSerializer serializer = new JSONAnnotationSerializer();
        String json = serializer.serialize(annotations);
        this.workflowDesignerPropertySet.setProperty(propKey, json);
    }
}

