/*
 * Decompiled with CFR 0.152.
 */
package com.sysbliss.jira.plugins.workflow.jgraph;

import com.atlassian.event.api.EventListener;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.StepDescriptor;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import com.sysbliss.jira.plugins.workflow.model.layout.EdgeLayout;
import com.sysbliss.jira.plugins.workflow.model.layout.EdgeLayoutImpl;
import com.sysbliss.jira.plugins.workflow.model.layout.JWDLayout;
import com.sysbliss.jira.plugins.workflow.model.layout.JWDLayoutImpl;
import com.sysbliss.jira.plugins.workflow.model.layout.LayoutPointImpl;
import com.sysbliss.jira.plugins.workflow.model.layout.LayoutRectImpl;
import com.sysbliss.jira.plugins.workflow.model.layout.NodeLayout;
import com.sysbliss.jira.plugins.workflow.model.layout.NodeLayoutImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class WorkflowToJWDLayout {
    private static final Comparator<NodeLayout> LAYOUT_COMPARATOR = new Comparator<NodeLayout>(){

        private int cmp(int one, int two) {
            if (one < two) {
                return -1;
            }
            if (one > two) {
                return 1;
            }
            return 0;
        }

        @Override
        public int compare(NodeLayout o1, NodeLayout o2) {
            int result = this.cmp(o1.getInLinks().size(), o2.getInLinks().size());
            if (result == 0) {
                result = this.cmp(o1.getStepId(), o2.getStepId());
            }
            return result;
        }
    };
    private final Map<StepDescriptor, NodeLayout> nodeCache = Maps.newIdentityHashMap();
    private final Map<ActionKey, EdgeLayout> edgeCache = Maps.newHashMap();
    private WorkflowDescriptor descriptor;

    private WorkflowToJWDLayout(WorkflowDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public static JWDLayout transform(JiraWorkflow workflow) {
        return WorkflowToJWDLayout.transform(workflow.getDescriptor());
    }

    static JWDLayout transform(WorkflowDescriptor workflow) {
        return new WorkflowToJWDLayout(workflow).transform();
    }

    private JWDLayout transform() {
        ArrayList roots = Lists.newArrayList();
        List initialActions = this.descriptor.getInitialActions();
        for (ActionDescriptor action : initialActions) {
            LayoutRectImpl rect = new LayoutRectImpl();
            rect.setX(0.0);
            rect.setY(0.0);
            rect.setWidth(0.0);
            rect.setHeight(0.0);
            NodeLayoutImpl rootLayout = new NodeLayoutImpl();
            rootLayout.setStepId(action.getId());
            rootLayout.setIsInitialAction(true);
            rootLayout.setRect(rect);
            rootLayout.setId(WorkflowToJWDLayout.createUIDForInitialAction(action));
            rootLayout.setLabel(action.getName());
            roots.add(rootLayout);
            this.createEdgeLayout(action, rootLayout, true);
        }
        List steps = this.descriptor.getSteps();
        if (!this.nodeCache.keySet().containsAll(steps)) {
            Set filteredSteps = Sets.newIdentityHashSet();
            filteredSteps.addAll(steps);
            filteredSteps.removeAll(this.nodeCache.keySet());
            ArrayList layouts = Lists.newArrayListWithExpectedSize((int)filteredSteps.size());
            for (StepDescriptor step : filteredSteps) {
                layouts.add(this.createNodeLayout(step));
            }
            Collections.sort(layouts, LAYOUT_COMPARATOR);
            Set candidates = Sets.newIdentityHashSet();
            candidates.addAll(layouts);
            Set<NodeLayout> allNodes = Sets.newIdentityHashSet();
            allNodes.addAll(layouts);
            allNodes = Collections.unmodifiableSet(allNodes);
            for (NodeLayout layout : layouts) {
                if (!candidates.contains(layout)) continue;
                Set visited = Sets.newIdentityHashSet();
                visited.add(layout);
                WorkflowToJWDLayout.findRoot(layout, candidates, allNodes, visited);
            }
            for (NodeLayout layout : layouts) {
                if (!candidates.contains(layout)) continue;
                roots.add(layout);
            }
        }
        JWDLayoutImpl jwdLayout = new JWDLayoutImpl();
        jwdLayout.setWidth(3072);
        jwdLayout.setRoots(roots);
        return jwdLayout;
    }

    private NodeLayout createNodeLayout(StepDescriptor step) {
        NodeLayout layout = this.nodeCache.get(step);
        if (layout != null) {
            return layout;
        }
        layout = new NodeLayoutImpl();
        LayoutRectImpl rect = new LayoutRectImpl();
        rect.setX(0.0);
        rect.setY(0.0);
        rect.setWidth(0.0);
        rect.setHeight(0.0);
        layout.setStepId(step.getId());
        layout.setIsInitialAction(false);
        layout.setRect(rect);
        layout.setId(WorkflowToJWDLayout.createUIDForStep(step));
        layout.setLabel(step.getName());
        this.nodeCache.put(step, layout);
        this.createEdgesForStartNode(layout, step);
        return layout;
    }

    private void createEdgesForStartNode(NodeLayout startNode, StepDescriptor startStep) {
        List outActions = startStep.getActions();
        for (ActionDescriptor action : outActions) {
            this.createEdgeLayout(action, startNode, false);
        }
    }

    private EdgeLayout createEdgeLayout(ActionDescriptor action, NodeLayout startNode, boolean initialAction) {
        ActionKey key = new ActionKey(action, startNode);
        EdgeLayout edgeLayout = this.edgeCache.get(key);
        if (edgeLayout != null) {
            return edgeLayout;
        }
        StepDescriptor endStep = this.getResultStep(action);
        if (endStep == null) {
            return null;
        }
        edgeLayout = new EdgeLayoutImpl();
        edgeLayout.setId(this.createUIDForAction(action, startNode.getId(), initialAction));
        edgeLayout.setLabel(action.getName());
        edgeLayout.setActionId(action.getId());
        edgeLayout.setStartStepId(startNode.getStepId());
        edgeLayout.setEndStepId(endStep.getId());
        edgeLayout.setStartNode(startNode);
        startNode.getOutLinks().add(edgeLayout);
        edgeLayout.setLineType("straight");
        LayoutPointImpl startPoint = new LayoutPointImpl();
        startPoint.setX(0.0);
        startPoint.setY(0.0);
        LayoutPointImpl endPoint = new LayoutPointImpl();
        endPoint.setX(0.0);
        endPoint.setY(0.0);
        LayoutPointImpl labelPoint = new LayoutPointImpl();
        labelPoint.setX(-200.0);
        labelPoint.setY(-200.0);
        edgeLayout.setStartPoint(startPoint);
        edgeLayout.setEndPoint(endPoint);
        edgeLayout.setLabelPoint(labelPoint);
        this.edgeCache.put(key, edgeLayout);
        NodeLayout endNode = this.createNodeLayout(endStep);
        edgeLayout.setEndNode(endNode);
        endNode.getInLinks().add(edgeLayout);
        return edgeLayout;
    }

    private static String createUIDForInitialAction(ActionDescriptor action) {
        return String.format("I<%d>", WorkflowToJWDLayout.getResultStepId(action));
    }

    private String createUIDForAction(ActionDescriptor action, String startStepId, boolean initial) {
        return String.format("%s<%d:%s:%s>", initial ? "IA" : "A", action.getId(), startStepId, WorkflowToJWDLayout.createUIDForStep(WorkflowToJWDLayout.getResultStepId(action)));
    }

    private static String createUIDForStep(int stepId) {
        return String.format("S<%d>", stepId);
    }

    private static String createUIDForStep(StepDescriptor step) {
        return WorkflowToJWDLayout.createUIDForStep(step.getId());
    }

    private static int getResultStepId(ActionDescriptor action) {
        return action.getUnconditionalResult().getStep();
    }

    private StepDescriptor getResultStep(ActionDescriptor action) {
        return this.descriptor.getStep(action.getUnconditionalResult().getStep());
    }

    private static void findRoot(NodeLayout node, Set<NodeLayout> candidates, Set<NodeLayout> allNodes, Set<NodeLayout> visited) {
        for (EdgeLayout layout : node.getOutLinks()) {
            NodeLayout endNode = layout.getEndNode();
            if (!allNodes.contains(endNode) || !visited.add(endNode)) continue;
            candidates.remove(endNode);
            WorkflowToJWDLayout.findRoot(endNode, candidates, allNodes, visited);
        }
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.edgeCache.clear();
        this.nodeCache.clear();
    }

    private static class ActionKey {
        private final int startStep;
        private final ActionDescriptor descriptor;

        private ActionKey(ActionDescriptor descriptor, int startStep) {
            this.descriptor = descriptor;
            this.startStep = startStep;
        }

        private ActionKey(ActionDescriptor descriptor, NodeLayout startStep) {
            this(descriptor, startStep.getStepId());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ActionKey actionKey = (ActionKey)o;
            return this.startStep == actionKey.startStep && this.descriptor == actionKey.descriptor;
        }

        public int hashCode() {
            return 31 * this.startStep + System.identityHashCode(this.descriptor);
        }
    }
}

