/*
 * Decompiled with CFR 0.152.
 */
package com.sysbliss.jira.plugins.workflow.jgraph;

import com.sysbliss.jira.plugins.workflow.jgraph.JWDLayoutVisitor;
import com.sysbliss.jira.plugins.workflow.model.layout.EdgeLayout;
import com.sysbliss.jira.plugins.workflow.model.layout.JWDLayout;
import com.sysbliss.jira.plugins.workflow.model.layout.NodeLayout;
import java.util.IdentityHashMap;
import java.util.Map;

class JWDLayoutWalker {
    private final Map<Object, Object> visited = new IdentityHashMap<Object, Object>();

    private JWDLayoutWalker() {
    }

    static void walk(JWDLayoutVisitor visitor, JWDLayout layout) {
        new JWDLayoutWalker().visit(visitor, layout);
    }

    private void visit(JWDLayoutVisitor visitor, JWDLayout layout) {
        if (!visitor.visitLayout(layout)) {
            return;
        }
        for (NodeLayout root : layout.getRoots()) {
            if (this.visitNode(visitor, root, true)) continue;
            return;
        }
    }

    private boolean visitNode(JWDLayoutVisitor visitor, NodeLayout node, boolean root) {
        if (this.visited.containsKey(node)) {
            return true;
        }
        boolean result = root ? visitor.visitRoot(node) : visitor.visitNode(node);
        if (!result) {
            return false;
        }
        this.visited.put(node, null);
        for (EdgeLayout edge : node.getOutLinks()) {
            if (this.visited.containsKey(edge)) continue;
            if (!visitor.visitEdge(edge)) {
                return false;
            }
            this.visited.put(edge, null);
            this.visitNode(visitor, edge.getEndNode(), false);
        }
        return true;
    }
}

